/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.configuration;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.configuration.FlinkOptions;
import org.apache.hudi.util.FlinkClientUtil;

public class HadoopConfigurations {
    public static final String HADOOP_PREFIX = "hadoop.";
    private static final String PARQUET_PREFIX = "parquet.";

    public static Configuration getParquetConf(org.apache.flink.configuration.Configuration options, Configuration hadoopConf) {
        Configuration copy2 = new Configuration(hadoopConf);
        Map<String, String> parquetOptions = FlinkOptions.getPropertiesWithPrefix(options.toMap(), PARQUET_PREFIX);
        parquetOptions.forEach((k, v) -> copy2.set(PARQUET_PREFIX + k, v));
        return copy2;
    }

    public static Configuration getHadoopConf(org.apache.flink.configuration.Configuration conf) {
        Configuration hadoopConf = FlinkClientUtil.getHadoopConf();
        Map<String, String> options = FlinkOptions.getPropertiesWithPrefix(conf.toMap(), HADOOP_PREFIX);
        options.forEach((arg_0, arg_1) -> ((Configuration)hadoopConf).set(arg_0, arg_1));
        return hadoopConf;
    }

    public static Configuration getHiveConf(org.apache.flink.configuration.Configuration conf) {
        String explicitDir = conf.getString(FlinkOptions.HIVE_SYNC_CONF_DIR, System.getenv("HIVE_CONF_DIR"));
        Configuration hadoopConf = new Configuration();
        if (explicitDir != null) {
            hadoopConf.addResource(new Path(explicitDir, "hive-site.xml"));
        }
        return hadoopConf;
    }
}

