/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.connect.kafka;

import java.util.Properties;
import org.apache.hudi.connect.ControlMessage;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaControlProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaControlProducer.class);
    private final String bootstrapServers;
    private final String controlTopicName;
    private Producer<String, byte[]> producer;

    public KafkaControlProducer(String bootstrapServers, String controlTopicName) {
        this.bootstrapServers = bootstrapServers;
        this.controlTopicName = controlTopicName;
        this.start();
    }

    private void start() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", ByteArraySerializer.class);
        this.producer = new KafkaProducer(props, (Serializer)new StringSerializer(), (Serializer)new ByteArraySerializer());
    }

    public void stop() {
        this.producer.close();
    }

    public void publishMessage(ControlMessage message) {
        ProducerRecord record = new ProducerRecord(this.controlTopicName, (Object)message.getType().name(), (Object)message.toByteArray());
        this.producer.send(record);
    }
}

