/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.connect.writers;

import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.HoodieJavaWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.connect.KafkaConnectFileIdPrefixProvider;
import org.apache.hudi.connect.utils.KafkaConnectUtils;
import org.apache.hudi.connect.writers.AbstractConnectWriter;
import org.apache.hudi.connect.writers.BufferedConnectWriter;
import org.apache.hudi.connect.writers.ConnectWriterProvider;
import org.apache.hudi.connect.writers.KafkaConnectConfigs;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.factory.HoodieAvroKeyGeneratorFactory;
import org.apache.hudi.schema.SchemaProvider;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaConnectWriterProvider
implements ConnectWriterProvider<WriteStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaConnectWriterProvider.class);
    private final KafkaConnectConfigs connectConfigs;
    private final HoodieEngineContext context;
    private final HoodieWriteConfig writeConfig;
    private final HoodieJavaWriteClient<HoodieAvroPayload> hudiJavaClient;
    private final KeyGenerator keyGenerator;
    private final SchemaProvider schemaProvider;

    public KafkaConnectWriterProvider(KafkaConnectConfigs connectConfigs, TopicPartition partition) throws HoodieException {
        this.connectConfigs = connectConfigs;
        StorageConfiguration<Configuration> storageConf = KafkaConnectUtils.getDefaultStorageConf(connectConfigs);
        try {
            this.schemaProvider = StringUtils.isNullOrEmpty(connectConfigs.getSchemaProviderClass()) ? null : (SchemaProvider)ReflectionUtils.loadClass(connectConfigs.getSchemaProviderClass(), connectConfigs.getProps());
            this.keyGenerator = HoodieAvroKeyGeneratorFactory.createKeyGenerator(connectConfigs.getProps());
            this.writeConfig = HoodieWriteConfig.newBuilder().withEngineType(EngineType.JAVA).withProperties(connectConfigs.getProps()).withFileIdPrefixProviderClassName(KafkaConnectFileIdPrefixProvider.class.getName()).withProps(Collections.singletonMap("hudi.kafka.connect.partition", String.valueOf(partition))).withSchema(this.schemaProvider.getSourceSchema().toString()).withAutoCommit(false).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.INMEMORY).build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().withAutoArchive(false).build()).withCleanConfig(HoodieCleanConfig.newBuilder().withAutoClean(false).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(false).build()).withClusteringConfig(HoodieClusteringConfig.newBuilder().withInlineClustering(false).build()).withWritesFileIdEncoding(1).build();
            this.context = new HoodieJavaEngineContext(storageConf);
            this.hudiJavaClient = new HoodieJavaWriteClient(this.context, this.writeConfig);
        }
        catch (Throwable e) {
            throw new HoodieException("Fatal error instantiating Hudi Write Provider ", e);
        }
    }

    public AbstractConnectWriter getWriter(String commitTime) {
        return new BufferedConnectWriter(this.context, this.hudiJavaClient, commitTime, this.connectConfigs, this.writeConfig, this.keyGenerator, this.schemaProvider);
    }
}

