/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.Iterator;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.queue.HoodieExecutor;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.HoodieLazyInsertIterable;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.util.ExecutorFactory;

public class JavaLazyInsertIterable<T>
extends HoodieLazyInsertIterable<T> {
    public JavaLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier) {
        super(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier);
    }

    public JavaLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, WriteHandleFactory writeHandleFactory) {
        super(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier, writeHandleFactory);
    }

    @Override
    protected List<WriteStatus> computeNext() {
        HoodieExecutor<List<WriteStatus>> executor = null;
        try {
            Schema schema = new Schema.Parser().parse(this.hoodieConfig.getSchema());
            executor = ExecutorFactory.create(this.hoodieConfig, this.inputItr, this.getInsertHandler(), this.getTransformer(schema, this.hoodieConfig));
            List<WriteStatus> result2 = executor.execute();
            ValidationUtils.checkState(result2 != null && !result2.isEmpty());
            List<WriteStatus> list = result2;
            return list;
        }
        catch (Exception e) {
            throw new HoodieException(e);
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
                executor.awaitTermination();
            }
        }
    }
}

