/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.util.Comparator;
import java.util.List;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.table.BulkInsertPartitioner;

public class JavaGlobalSortPartitioner<T>
implements BulkInsertPartitioner<List<HoodieRecord<T>>> {
    @Override
    public List<HoodieRecord<T>> repartitionRecords(List<HoodieRecord<T>> records, int outputPartitions) {
        records.sort(new Comparator(){

            public int compare(Object o1, Object o2) {
                HoodieRecord o11 = (HoodieRecord)o1;
                HoodieRecord o22 = (HoodieRecord)o2;
                String left = o11.getPartitionPath() + "+" + o11.getRecordKey();
                String right = o22.getPartitionPath() + "+" + o22.getRecordKey();
                return left.compareTo(right);
            }
        });
        return records;
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return true;
    }
}

