/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.fs.inline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class InMemoryFileSystem
extends FileSystem {
    private ByteArrayOutputStream bos;
    private Configuration conf = null;
    public static final String SCHEME = "inmemfs";
    private URI uri;

    InMemoryFileSystem() {
    }

    public void initialize(URI name2, Configuration conf) throws IOException {
        super.initialize(name2, conf);
        this.conf = conf;
        this.uri = name2;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getScheme() {
        return SCHEME;
    }

    public FSDataInputStream open(Path inlinePath, int bufferSize) {
        return null;
    }

    public FSDataOutputStream create(Path path, FsPermission fsPermission, boolean b, int i, short i1, long l, Progressable progressable) throws IOException {
        this.bos = new ByteArrayOutputStream();
        try {
            this.uri = new URI(path.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Path not parsable as URI " + path);
        }
        return new FSDataOutputStream((OutputStream)this.bos, new FileSystem.Statistics(this.getScheme()));
    }

    public byte[] getFileAsBytes() {
        return this.bos.toByteArray();
    }

    public FSDataOutputStream append(Path path, int i, Progressable progressable) throws IOException {
        return null;
    }

    public boolean rename(Path path, Path path1) throws IOException {
        throw new UnsupportedOperationException("Can't rename files");
    }

    public boolean delete(Path path, boolean b) throws IOException {
        throw new UnsupportedOperationException("Can't delete files");
    }

    public FileStatus[] listStatus(Path inlinePath) throws IOException {
        throw new UnsupportedOperationException("No support for listStatus");
    }

    public void setWorkingDirectory(Path path) {
        throw new UnsupportedOperationException("Can't set working directory");
    }

    public Path getWorkingDirectory() {
        return null;
    }

    public boolean mkdirs(Path path, FsPermission fsPermission) throws IOException {
        throw new UnsupportedOperationException("Can't mkdir");
    }

    public boolean exists(Path f) throws IOException {
        throw new UnsupportedOperationException("Can't check for exists");
    }

    public FileStatus getFileStatus(Path inlinePath) throws IOException {
        throw new UnsupportedOperationException("No support for getFileStatus");
    }

    public void close() throws IOException {
        super.close();
        this.bos.close();
    }
}

