/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.parquet.schema.MessageType;

public class SchemaDifference {
    private final MessageType storageSchema;
    private final Map<String, String> tableSchema;
    private final List<String> deleteColumns;
    private final Map<String, String> updateColumnTypes;
    private final Map<String, String> addColumnTypes;

    private SchemaDifference(MessageType storageSchema, Map<String, String> tableSchema, List<String> deleteColumns, Map<String, String> updateColumnTypes, Map<String, String> addColumnTypes) {
        this.storageSchema = storageSchema;
        this.tableSchema = tableSchema;
        this.deleteColumns = Collections.unmodifiableList(deleteColumns);
        this.updateColumnTypes = Collections.unmodifiableMap(updateColumnTypes);
        this.addColumnTypes = Collections.unmodifiableMap(addColumnTypes);
    }

    public List<String> getDeleteColumns() {
        return this.deleteColumns;
    }

    public Map<String, String> getUpdateColumnTypes() {
        return this.updateColumnTypes;
    }

    public Map<String, String> getAddColumnTypes() {
        return this.addColumnTypes;
    }

    public static Builder newBuilder(MessageType storageSchema, Map<String, String> tableSchema) {
        return new Builder(storageSchema, tableSchema);
    }

    public boolean isEmpty() {
        return this.deleteColumns.isEmpty() && this.updateColumnTypes.isEmpty() && this.addColumnTypes.isEmpty();
    }

    public String toString() {
        return new StringJoiner(", ", SchemaDifference.class.getSimpleName() + "[", "]").add("storageSchema=" + this.storageSchema).add("tableSchema=" + this.tableSchema).add("deleteColumns=" + this.deleteColumns).add("updateColumnTypes=" + this.updateColumnTypes).add("addColumnTypes=" + this.addColumnTypes).toString();
    }

    public static class Builder {
        private final MessageType storageSchema;
        private final Map<String, String> tableSchema;
        private final List<String> deleteColumns;
        private final Map<String, String> updateColumnTypes;
        private final Map<String, String> addColumnTypes;

        public Builder(MessageType storageSchema, Map<String, String> tableSchema) {
            this.storageSchema = storageSchema;
            this.tableSchema = tableSchema;
            this.deleteColumns = new ArrayList<String>();
            this.updateColumnTypes = new HashMap<String, String>();
            this.addColumnTypes = new LinkedHashMap<String, String>();
        }

        public Builder deleteTableColumn(String column) {
            this.deleteColumns.add(column);
            return this;
        }

        public Builder updateTableColumn(String column, String storageColumnType) {
            this.updateColumnTypes.put(column, storageColumnType);
            return this;
        }

        public Builder addTableColumn(String name2, String type2) {
            this.addColumnTypes.put(name2, type2);
            return this;
        }

        public SchemaDifference build() {
            return new SchemaDifference(this.storageSchema, this.tableSchema, this.deleteColumns, this.updateColumnTypes, this.addColumnTypes);
        }
    }
}

