/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.exception.HoodieMetadataIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.io.HoodieMergedReadHandle;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.factory.HoodieAvroKeyGeneratorFactory;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.HoodieDeleteHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieIndexUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieIndexUtils.class);

    public static List<HoodieBaseFile> getLatestBaseFilesForPartition(String partition, HoodieTable hoodieTable) {
        Option<HoodieInstant> latestCommitTime = hoodieTable.getMetaClient().getCommitsTimeline().filterCompletedInstants().lastInstant();
        if (latestCommitTime.isPresent()) {
            return hoodieTable.getBaseFileOnlyView().getLatestBaseFilesBeforeOrOn(partition, latestCommitTime.get().requestedTime()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<FileSlice> getLatestFileSlicesForPartition(String partition, HoodieTable hoodieTable) {
        Option<HoodieInstant> latestCommitTime = hoodieTable.getMetaClient().getCommitsTimeline().filterCompletedInstants().lastInstant();
        if (latestCommitTime.isPresent()) {
            return hoodieTable.getHoodieView().getLatestFileSlicesBeforeOrOn(partition, latestCommitTime.get().requestedTime(), true).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static List<Pair<String, HoodieBaseFile>> getLatestBaseFilesForAllPartitions(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        context.setJobStatus(HoodieIndexUtils.class.getSimpleName(), "Load latest base files from all partitions: " + hoodieTable.getConfig().getTableName());
        return context.flatMap(partitions, partitionPath -> {
            List filteredFiles = HoodieIndexUtils.getLatestBaseFilesForPartition(partitionPath, hoodieTable).stream().map(baseFile -> Pair.of(partitionPath, baseFile)).collect(Collectors.toList());
            return filteredFiles.stream();
        }, Math.max(partitions.size(), 1));
    }

    public static <R> HoodieRecord<R> tagAsNewRecordIfNeeded(HoodieRecord<R> record, Option<HoodieRecordLocation> location) {
        if (location.isPresent()) {
            HoodieRecord<R> newRecord = record.newInstance();
            newRecord.unseal();
            newRecord.setCurrentLocation(location.get());
            newRecord.seal();
            return newRecord;
        }
        return record;
    }

    public static <R> HoodieRecord<R> tagRecord(HoodieRecord<R> record, HoodieRecordLocation location) {
        record.unseal();
        record.setCurrentLocation(location);
        record.seal();
        return record;
    }

    public static List<Pair<String, Long>> filterKeysFromFile(StoragePath filePath, List<String> candidateRecordKeys, HoodieStorage storage2) throws HoodieIndexException {
        ValidationUtils.checkArgument(FSUtils.isBaseFile(filePath));
        ArrayList<Pair<String, Long>> foundRecordKeys = new ArrayList<Pair<String, Long>>();
        try (HoodieFileReader fileReader = HoodieIOFactory.getIOFactory(storage2).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(ConfigUtils.DEFAULT_HUDI_CONFIG_FOR_READER, filePath);){
            if (!candidateRecordKeys.isEmpty()) {
                HoodieTimer timer = HoodieTimer.start();
                Set<Pair<String, Long>> fileRowKeys = fileReader.filterRowKeys(candidateRecordKeys.stream().collect(Collectors.toSet()));
                foundRecordKeys.addAll(fileRowKeys);
                LOG.info(String.format("Checked keys against file %s, in %d ms. #candidates (%d) #found (%d)", filePath, timer.endTimer(), candidateRecordKeys.size(), foundRecordKeys.size()));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Keys matching for file " + filePath + " => " + foundRecordKeys);
                }
            }
        }
        catch (Exception e) {
            throw new HoodieIndexException("Error checking candidate keys against file.", e);
        }
        return foundRecordKeys;
    }

    public static boolean checkIfValidCommit(HoodieTimeline commitTimeline, String commitTs) {
        return !commitTimeline.empty() && commitTimeline.containsOrBeforeTimelineStarts(commitTs);
    }

    public static HoodieIndex createUserDefinedIndex(HoodieWriteConfig config) {
        Object instance = ReflectionUtils.loadClass(config.getIndexClass(), config);
        if (!(instance instanceof HoodieIndex)) {
            throw new HoodieIndexException(config.getIndexClass() + " is not a subclass of HoodieIndex");
        }
        return (HoodieIndex)instance;
    }

    private static <R> HoodieData<HoodieRecord<R>> getExistingRecords(HoodieData<Pair<String, String>> partitionLocations, HoodieWriteConfig config, HoodieTable hoodieTable) {
        Option<String> instantTime = hoodieTable.getMetaClient().getActiveTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::requestedTime);
        return partitionLocations.flatMap(p -> new HoodieMergedReadHandle(config, instantTime, hoodieTable, Pair.of(p.getKey(), p.getValue())).getMergedRecords().iterator());
    }

    private static Pair<HoodieWriteConfig, Option<BaseKeyGenerator>> getKeygenAndUpdatedWriteConfig(HoodieWriteConfig config, HoodieTableConfig tableConfig) {
        if (config.getPayloadClass().equals("org.apache.spark.sql.hudi.command.payload.ExpressionPayload")) {
            TypedProperties typedProperties = TypedProperties.copy(config.getProps());
            typedProperties.setProperty(HoodieWriteConfig.WRITE_PAYLOAD_CLASS_NAME.key(), tableConfig.getPayloadClass());
            typedProperties.setProperty(HoodieTableConfig.PAYLOAD_CLASS_NAME.key(), tableConfig.getPayloadClass());
            HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withProperties(typedProperties).build();
            try {
                return Pair.of(writeConfig, Option.of((BaseKeyGenerator)HoodieAvroKeyGeneratorFactory.createKeyGenerator(writeConfig.getProps())));
            }
            catch (IOException e) {
                throw new RuntimeException("KeyGenerator must inherit from BaseKeyGenerator to update a records partition path using spark sql merge into", e);
            }
        }
        return Pair.of(config, Option.empty());
    }

    private static <R> Option<HoodieRecord<R>> mergeIncomingWithExistingRecordWithExpressionPayload(HoodieRecord<R> incoming, HoodieRecord<R> existing, Schema writeSchema, Schema existingSchema, Schema writeSchemaWithMetaFields, HoodieWriteConfig config, HoodieRecordMerger recordMerger, BaseKeyGenerator keyGenerator) throws IOException {
        Option<Pair<HoodieRecord, Schema>> mergeResult = recordMerger.merge(existing, existingSchema, incoming, writeSchemaWithMetaFields, config.getProps());
        if (!mergeResult.isPresent()) {
            return Option.empty();
        }
        HoodieRecord result2 = mergeResult.get().getLeft();
        if (result2.getData().equals(HoodieRecord.SENTINEL)) {
            return Option.of(result2);
        }
        String partitionPath = keyGenerator.getPartitionPath((GenericRecord)result2.getData());
        HoodieRecord withMeta = result2.prependMetaFields(writeSchema, writeSchemaWithMetaFields, new MetadataValues().setRecordKey(incoming.getRecordKey()).setPartitionPath(partitionPath), config.getProps());
        return Option.of(withMeta.wrapIntoHoodieRecordPayloadWithParams(writeSchemaWithMetaFields, config.getProps(), Option.empty(), config.allowOperationMetadataField(), Option.empty(), false, Option.of(writeSchema)));
    }

    private static <R> Option<HoodieRecord<R>> mergeIncomingWithExistingRecord(HoodieRecord<R> incoming, HoodieRecord<R> existing, Schema writeSchema, HoodieWriteConfig config, HoodieRecordMerger recordMerger, Option<BaseKeyGenerator> expressionPayloadKeygen) throws IOException {
        Schema existingSchema = HoodieAvroUtils.addMetadataFields(new Schema.Parser().parse(config.getSchema()), config.allowOperationMetadataField());
        Schema writeSchemaWithMetaFields = HoodieAvroUtils.addMetadataFields(writeSchema, config.allowOperationMetadataField());
        if (expressionPayloadKeygen.isPresent()) {
            return HoodieIndexUtils.mergeIncomingWithExistingRecordWithExpressionPayload(incoming, existing, writeSchema, existingSchema, writeSchemaWithMetaFields, config, recordMerger, expressionPayloadKeygen.get());
        }
        HoodieRecord incomingPrepended = incoming.prependMetaFields(writeSchema, writeSchemaWithMetaFields, new MetadataValues().setRecordKey(incoming.getRecordKey()).setPartitionPath(incoming.getPartitionPath()), config.getProps());
        HoodieRecord incomingWithMetaFields = incomingPrepended.wrapIntoHoodieRecordPayloadWithParams(writeSchemaWithMetaFields, config.getProps(), Option.empty(), config.allowOperationMetadataField(), Option.empty(), false, Option.empty());
        Option<Pair<HoodieRecord, Schema>> mergeResult = recordMerger.merge(existing, existingSchema, incomingWithMetaFields, writeSchemaWithMetaFields, config.getProps());
        if (mergeResult.isPresent()) {
            HoodieRecord merged = mergeResult.get().getLeft().wrapIntoHoodieRecordPayloadWithParams(writeSchemaWithMetaFields, config.getProps(), Option.empty(), config.allowOperationMetadataField(), Option.empty(), false, Option.of(writeSchema));
            return Option.of(merged);
        }
        return Option.empty();
    }

    public static <R> HoodieData<HoodieRecord<R>> mergeForPartitionUpdatesIfNeeded(HoodieData<Pair<HoodieRecord<R>, Option<HoodieRecordGlobalLocation>>> incomingRecordsAndLocations, HoodieWriteConfig config, HoodieTable hoodieTable) {
        Pair<HoodieWriteConfig, Option<BaseKeyGenerator>> keyGeneratorWriteConfigOpt = HoodieIndexUtils.getKeygenAndUpdatedWriteConfig(config, hoodieTable.getMetaClient().getTableConfig());
        HoodieWriteConfig updatedConfig = keyGeneratorWriteConfigOpt.getLeft();
        Option<BaseKeyGenerator> expressionPayloadKeygen = keyGeneratorWriteConfigOpt.getRight();
        HoodieData<HoodieRecord> taggedNewRecords = incomingRecordsAndLocations.filter(p -> !((Option)p.getRight()).isPresent()).map(Pair::getLeft);
        HoodieData<HoodieRecord> untaggedUpdatingRecords = incomingRecordsAndLocations.filter(p -> ((Option)p.getRight()).isPresent()).map(Pair::getLeft).distinctWithKey(HoodieRecord::getRecordKey, updatedConfig.getGlobalIndexReconcileParallelism());
        HoodieData<Pair<String, String>> globalLocations = incomingRecordsAndLocations.filter(p -> ((Option)p.getRight()).isPresent()).map(p -> Pair.of(((HoodieRecordGlobalLocation)((Option)p.getRight()).get()).getPartitionPath(), ((HoodieRecordGlobalLocation)((Option)p.getRight()).get()).getFileId())).distinct(updatedConfig.getGlobalIndexReconcileParallelism());
        HoodieData<HoodieRecord<R>> existingRecords = HoodieIndexUtils.getExistingRecords(globalLocations, keyGeneratorWriteConfigOpt.getLeft(), hoodieTable);
        HoodieRecordMerger recordMerger = updatedConfig.getRecordMerger();
        HoodieData taggedUpdatingRecords = untaggedUpdatingRecords.mapToPair(r -> Pair.of(r.getRecordKey(), r)).leftOuterJoin(existingRecords.mapToPair(r -> Pair.of(r.getRecordKey(), r))).values().flatMap(entry -> {
            HoodieRecord incoming = (HoodieRecord)entry.getLeft();
            Option existingOpt = (Option)entry.getRight();
            if (!existingOpt.isPresent()) {
                return Collections.singletonList(incoming).iterator();
            }
            HoodieRecord existing = (HoodieRecord)existingOpt.get();
            Schema writeSchema = new Schema.Parser().parse(updatedConfig.getWriteSchema());
            if (incoming.isDelete(writeSchema, updatedConfig.getProps())) {
                return Collections.singletonList(HoodieIndexUtils.tagRecord(incoming.newInstance(existing.getKey()), existing.getCurrentLocation())).iterator();
            }
            Option mergedOpt = HoodieIndexUtils.mergeIncomingWithExistingRecord(incoming, existing, writeSchema, updatedConfig, recordMerger, expressionPayloadKeygen);
            if (!mergedOpt.isPresent()) {
                return Collections.singletonList(HoodieIndexUtils.tagRecord(incoming.newInstance(existing.getKey()), existing.getCurrentLocation())).iterator();
            }
            HoodieRecord merged = mergedOpt.get();
            if (merged.getData().equals(HoodieRecord.SENTINEL)) {
                return Collections.emptyIterator();
            }
            if (Objects.equals(merged.getPartitionPath(), existing.getPartitionPath())) {
                return Collections.singletonList(HoodieIndexUtils.tagRecord(merged, existing.getCurrentLocation())).iterator();
            }
            HoodieRecord deleteRecord = HoodieDeleteHelper.createDeleteRecord(updatedConfig, existing.getKey());
            deleteRecord.setIgnoreIndexUpdate(true);
            return Arrays.asList(HoodieIndexUtils.tagRecord(deleteRecord, existing.getCurrentLocation()), merged).iterator();
        });
        return taggedUpdatingRecords.union(taggedNewRecords);
    }

    public static <R> HoodieData<HoodieRecord<R>> tagGlobalLocationBackToRecords(HoodieData<HoodieRecord<R>> incomingRecords, HoodiePairData<String, HoodieRecordGlobalLocation> keyAndExistingLocations, boolean mayContainDuplicateLookup, boolean shouldUpdatePartitionPath, HoodieWriteConfig config, HoodieTable table) {
        HoodieRecordMerger merger = config.getRecordMerger();
        HoodiePairData keyAndIncomingRecords = incomingRecords.mapToPair(record -> Pair.of(record.getRecordKey(), record));
        HoodieData<Pair<HoodieRecord<R>, Option<HoodieRecordGlobalLocation>>> incomingRecordsAndLocations = keyAndIncomingRecords.leftOuterJoin(keyAndExistingLocations).values().map(v -> {
            HoodieRecord incomingRecord = (HoodieRecord)v.getLeft();
            Option<Object> currentLocOpt = Option.ofNullable(((Option)v.getRight()).orElse(null));
            if (currentLocOpt.isPresent()) {
                boolean shouldDoMergedLookUpThenTag;
                HoodieRecordGlobalLocation currentLoc = currentLocOpt.get();
                boolean bl = shouldDoMergedLookUpThenTag = mayContainDuplicateLookup || !Objects.equals(incomingRecord.getPartitionPath(), currentLoc.getPartitionPath());
                if (shouldUpdatePartitionPath && shouldDoMergedLookUpThenTag) {
                    return Pair.of(incomingRecord, currentLocOpt);
                }
                return Pair.of(HoodieIndexUtils.createNewTaggedHoodieRecord(incomingRecord, currentLoc, merger.getRecordType()), Option.empty());
            }
            return Pair.of(incomingRecord, Option.empty());
        });
        return shouldUpdatePartitionPath ? HoodieIndexUtils.mergeForPartitionUpdatesIfNeeded(incomingRecordsAndLocations, config, table) : incomingRecordsAndLocations.map(Pair::getLeft);
    }

    public static <R> HoodieRecord<R> createNewTaggedHoodieRecord(HoodieRecord<R> oldRecord, HoodieRecordGlobalLocation location, HoodieRecord.HoodieRecordType recordType) {
        switch (recordType) {
            case AVRO: {
                HoodieKey recordKey = new HoodieKey(oldRecord.getRecordKey(), location.getPartitionPath());
                return HoodieIndexUtils.tagRecord(new HoodieAvroRecord<HoodieRecordPayload>(recordKey, (HoodieRecordPayload)oldRecord.getData()), location);
            }
            case SPARK: {
                return HoodieIndexUtils.tagRecord(oldRecord.newInstance(), location);
            }
        }
        throw new HoodieIndexException("Unsupported record type: " + (Object)((Object)recordType));
    }

    public static void register(HoodieTableMetaClient metaClient, HoodieIndexDefinition indexDefinition) {
        LOG.info("Registering index {} of using {}", (Object)indexDefinition.getIndexName(), (Object)indexDefinition.getIndexType());
        boolean indexDefnUpdated = metaClient.buildIndexDefinition(indexDefinition);
        if (indexDefnUpdated) {
            String indexMetaPath = metaClient.getIndexDefinitionPath();
            if (!metaClient.getTableConfig().getProps().containsKey(HoodieTableConfig.RELATIVE_INDEX_DEFINITION_PATH.key()) || !metaClient.getTableConfig().getRelativeIndexDefinitionPath().isPresent()) {
                metaClient.getTableConfig().setValue(HoodieTableConfig.RELATIVE_INDEX_DEFINITION_PATH, FSUtils.getRelativePartitionPath(metaClient.getBasePath(), new StoragePath(indexMetaPath)));
                HoodieTableConfig.update(metaClient.getStorage(), metaClient.getMetaPath(), metaClient.getTableConfig().getProps());
            }
        }
    }

    static HoodieIndexDefinition getSecondaryOrExpressionIndexDefinition(HoodieTableMetaClient metaClient, String userIndexName, String indexType, Map<String, Map<String, String>> columns, Map<String, String> options, Map<String, String> tableProperties) throws Exception {
        String fullIndexName;
        String string = fullIndexName = indexType.equals("secondary_index") ? "secondary_index_" + userIndexName : "expr_index_" + userIndexName;
        if (HoodieIndexUtils.indexExists(metaClient, fullIndexName)) {
            throw new HoodieMetadataIndexException("Index already exists: " + userIndexName);
        }
        ValidationUtils.checkArgument(columns.size() == 1, "Only one column can be indexed for functional or secondary index.");
        if (!HoodieIndexUtils.isEligibleForSecondaryOrExpressionIndex(metaClient, indexType, tableProperties, columns)) {
            throw new HoodieMetadataIndexException("Not eligible for indexing: " + indexType + ", indexName: " + userIndexName);
        }
        return HoodieIndexDefinition.newBuilder().withIndexName(fullIndexName).withIndexType(indexType).withIndexFunction(options.getOrDefault("expr", "identity")).withSourceFields(new ArrayList<String>(columns.keySet())).withIndexOptions(options).build();
    }

    static boolean indexExists(HoodieTableMetaClient metaClient, String indexName) {
        return metaClient.getTableConfig().getMetadataPartitions().stream().anyMatch(partition -> partition.equals(indexName));
    }

    private static boolean isEligibleForSecondaryOrExpressionIndex(HoodieTableMetaClient metaClient, String indexType, Map<String, String> options, Map<String, Map<String, String>> columns) throws Exception {
        if (!HoodieTableMetadataUtil.validateDataTypeForSecondaryOrExpressionIndex(new ArrayList<String>(columns.keySet()), new TableSchemaResolver(metaClient).getTableAvroSchema())) {
            return false;
        }
        if (indexType.equals("secondary_index")) {
            return metaClient.getTableConfig().getMetadataPartitions().stream().anyMatch(partition -> partition.equals(MetadataPartitionType.RECORD_INDEX.getPartitionPath())) || Boolean.parseBoolean(options.getOrDefault(HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.key(), HoodieMetadataConfig.RECORD_INDEX_ENABLE_PROP.defaultValue().toString()));
        }
        return true;
    }
}

