/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.io.Serializable;
import java.util.Objects;

public class BloomIndexFileInfo
implements Serializable {
    private final String fileId;
    private final String minRecordKey;
    private final String maxRecordKey;

    public BloomIndexFileInfo(String fileId, String minRecordKey, String maxRecordKey) {
        this.fileId = fileId;
        this.minRecordKey = minRecordKey;
        this.maxRecordKey = maxRecordKey;
    }

    public BloomIndexFileInfo(String fileId) {
        this.fileId = fileId;
        this.minRecordKey = null;
        this.maxRecordKey = null;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getMinRecordKey() {
        return this.minRecordKey;
    }

    public String getMaxRecordKey() {
        return this.maxRecordKey;
    }

    public boolean hasKeyRanges() {
        return this.minRecordKey != null && this.maxRecordKey != null;
    }

    public boolean isKeyInRange(String recordKey) {
        return Objects.requireNonNull(this.minRecordKey).compareTo(recordKey) <= 0 && Objects.requireNonNull(this.maxRecordKey).compareTo(recordKey) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BloomIndexFileInfo that = (BloomIndexFileInfo)o;
        return Objects.equals(that.fileId, this.fileId) && Objects.equals(that.minRecordKey, this.minRecordKey) && Objects.equals(that.maxRecordKey, this.maxRecordKey);
    }

    public int hashCode() {
        return Objects.hash(this.fileId, this.minRecordKey, this.maxRecordKey);
    }

    public String toString() {
        return "BloomIndexFileInfo { fileId=" + this.fileId + " minRecordKey=" + this.minRecordKey + " maxRecordKey=" + this.maxRecordKey + '}';
    }
}

