/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.MetadataNotFoundException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.IndexFileFilter;
import org.apache.hudi.index.bloom.IntervalTreeBasedIndexFileFilter;
import org.apache.hudi.index.bloom.ListBasedIndexFileFilter;
import org.apache.hudi.io.HoodieRangeInfoHandle;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieBloomIndex
extends HoodieIndex<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieBloomIndex.class);
    private final BaseHoodieBloomIndexHelper bloomIndexHelper;

    public HoodieBloomIndex(HoodieWriteConfig config, BaseHoodieBloomIndexHelper bloomIndexHelper) {
        super(config);
        this.bloomIndexHelper = bloomIndexHelper;
    }

    @Override
    public <R> HoodieData<HoodieRecord<R>> tagLocation(HoodieData<HoodieRecord<R>> records, HoodieEngineContext context, HoodieTable hoodieTable) {
        if (this.config.getBloomIndexUseCaching()) {
            records.persist(this.config.getBloomIndexInputStorageLevel());
        }
        HoodiePairData<String, String> partitionRecordKeyPairs = records.mapToPair(record -> new ImmutablePair<String, String>(record.getPartitionPath(), record.getRecordKey()));
        HoodiePairData<HoodieKey, HoodieRecordLocation> keyFilenamePairs = this.lookupIndex(partitionRecordKeyPairs, context, hoodieTable);
        if (this.config.getBloomIndexUseCaching()) {
            keyFilenamePairs.persist(this.config.getBloomIndexInputStorageLevel());
        }
        if (LOG.isDebugEnabled()) {
            long totalTaggedRecords = keyFilenamePairs.count();
            LOG.debug("Number of update records (ones tagged with a fileID): " + totalTaggedRecords);
        }
        HoodieData<HoodieRecord<R>> taggedRecords = this.tagLocationBacktoRecords(keyFilenamePairs, records, hoodieTable);
        if (this.config.getBloomIndexUseCaching()) {
            records.unpersist();
            keyFilenamePairs.unpersist();
        }
        return taggedRecords;
    }

    private HoodiePairData<HoodieKey, HoodieRecordLocation> lookupIndex(HoodiePairData<String, String> partitionRecordKeyPairs, HoodieEngineContext context, HoodieTable hoodieTable) {
        Map<String, Long> recordsPerPartition = partitionRecordKeyPairs.countByKey();
        ArrayList<String> affectedPartitionPathList = new ArrayList<String>(recordsPerPartition.keySet());
        List<Pair<String, BloomIndexFileInfo>> fileInfoList = this.getBloomIndexFileInfoForPartitions(context, hoodieTable, affectedPartitionPathList);
        Map<String, List<BloomIndexFileInfo>> partitionToFileInfo = fileInfoList.stream().collect(Collectors.groupingBy(Pair::getLeft, Collectors.mapping(Pair::getRight, Collectors.toList())));
        HoodiePairData<HoodieFileGroupId, String> fileComparisonPairs = this.explodeRecordsWithFileComparisons(partitionToFileInfo, partitionRecordKeyPairs);
        return this.bloomIndexHelper.findMatchingFilesForRecordKeys(this.config, context, hoodieTable, partitionRecordKeyPairs, fileComparisonPairs, partitionToFileInfo, recordsPerPartition);
    }

    private List<Pair<String, BloomIndexFileInfo>> getBloomIndexFileInfoForPartitions(HoodieEngineContext context, HoodieTable hoodieTable, List<String> affectedPartitionPathList) {
        List<Object> fileInfoList = new ArrayList();
        if (this.config.getBloomIndexPruneByRanges()) {
            if (this.config.getBloomIndexUseMetadata() && hoodieTable.getMetaClient().getTableConfig().getMetadataPartitions().contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath())) {
                fileInfoList = this.loadColumnRangesFromMetaIndex(affectedPartitionPathList, context, hoodieTable);
            }
            if (CollectionUtils.isNullOrEmpty(fileInfoList)) {
                LOG.warn("fallback to loading column ranges from files");
                fileInfoList = this.loadColumnRangesFromFiles(affectedPartitionPathList, context, hoodieTable);
            }
        } else {
            fileInfoList = this.getFileInfoForLatestBaseFiles(affectedPartitionPathList, context, hoodieTable);
        }
        return fileInfoList;
    }

    List<Pair<String, BloomIndexFileInfo>> loadColumnRangesFromFiles(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        List partitionPathFileIDList = HoodieIndexUtils.getLatestBaseFilesForAllPartitions(partitions, context, hoodieTable).stream().map(pair -> Pair.of(pair.getKey(), Pair.of(((HoodieBaseFile)pair.getValue()).getFileId(), pair.getValue()))).collect(Collectors.toList());
        context.setJobStatus(this.getClass().getName(), "Obtain key ranges for file slices (range pruning=on): " + this.config.getTableName());
        return context.map(partitionPathFileIDList, pf -> {
            try {
                HoodieRangeInfoHandle rangeInfoHandle = new HoodieRangeInfoHandle(this.config, hoodieTable, Pair.of(pf.getKey(), ((Pair)pf.getValue()).getKey()));
                String[] minMaxKeys = rangeInfoHandle.getMinMaxKeys((HoodieBaseFile)((Pair)pf.getValue()).getValue());
                return Pair.of(pf.getKey(), new BloomIndexFileInfo((String)((Pair)pf.getValue()).getKey(), minMaxKeys[0], minMaxKeys[1]));
            }
            catch (MetadataNotFoundException me) {
                LOG.warn("Unable to find range metadata in file :" + pf);
                return Pair.of(pf.getKey(), new BloomIndexFileInfo((String)((Pair)pf.getValue()).getKey()));
            }
        }, Math.max(partitionPathFileIDList.size(), 1));
    }

    private List<Pair<String, BloomIndexFileInfo>> getFileInfoForLatestBaseFiles(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        List partitionPathFileIDList = HoodieIndexUtils.getLatestBaseFilesForAllPartitions(partitions, context, hoodieTable).stream().map(pair -> Pair.of(pair.getKey(), ((HoodieBaseFile)pair.getValue()).getFileId())).collect(Collectors.toList());
        return partitionPathFileIDList.stream().map(pf -> Pair.of(pf.getKey(), new BloomIndexFileInfo((String)pf.getValue()))).collect(Collectors.toList());
    }

    protected List<Pair<String, BloomIndexFileInfo>> loadColumnRangesFromMetaIndex(List<String> partitions, HoodieEngineContext context, HoodieTable<?, ?, ?, ?> hoodieTable) {
        context.setJobStatus(this.getClass().getName(), "Load meta index key ranges for file slices: " + this.config.getTableName());
        String keyField = HoodieRecord.HoodieMetadataField.RECORD_KEY_METADATA_FIELD.getFieldName();
        List<Pair<String, HoodieBaseFile>> baseFilesForAllPartitions = HoodieIndexUtils.getLatestBaseFilesForAllPartitions(partitions, context, hoodieTable);
        ArrayList<Pair<String, String>> partitionFileNameList = new ArrayList<Pair<String, String>>(baseFilesForAllPartitions.size());
        HashMap partitionAndFileNameToFileId = new HashMap(baseFilesForAllPartitions.size(), 1.0f);
        baseFilesForAllPartitions.forEach(pair -> {
            Pair partitionAndFileName = Pair.of(pair.getKey(), ((HoodieBaseFile)pair.getValue()).getFileName());
            partitionFileNameList.add(partitionAndFileName);
            partitionAndFileNameToFileId.put(partitionAndFileName, ((HoodieBaseFile)pair.getValue()).getFileId());
        });
        if (partitionFileNameList.isEmpty()) {
            return Collections.emptyList();
        }
        Map<Pair<String, String>, HoodieMetadataColumnStats> fileToColumnStatsMap = hoodieTable.getMetadataTable().getColumnStats(partitionFileNameList, keyField);
        ArrayList<Pair<String, BloomIndexFileInfo>> result2 = new ArrayList<Pair<String, BloomIndexFileInfo>>(fileToColumnStatsMap.size());
        for (Map.Entry<Pair<String, String>, HoodieMetadataColumnStats> entry : fileToColumnStatsMap.entrySet()) {
            result2.add(Pair.of(entry.getKey().getLeft(), new BloomIndexFileInfo((String)partitionAndFileNameToFileId.get(entry.getKey()), HoodieAvroUtils.unwrapAvroValueWrapper(entry.getValue().getMinValue()).toString(), HoodieAvroUtils.unwrapAvroValueWrapper(entry.getValue().getMaxValue()).toString())));
        }
        return result2;
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean canIndexLogFiles() {
        return false;
    }

    @Override
    public boolean isImplicitWithStorage() {
        return true;
    }

    HoodiePairData<HoodieFileGroupId, String> explodeRecordsWithFileComparisons(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo, HoodiePairData<String, String> partitionRecordKeyPairs) {
        LOG.info("Instantiating index file filter ");
        IndexFileFilter indexFileFilter = this.config.useBloomIndexTreebasedFilter() ? new IntervalTreeBasedIndexFileFilter(partitionToFileIndexInfo) : new ListBasedIndexFileFilter(partitionToFileIndexInfo);
        return partitionRecordKeyPairs.map(partitionRecordKeyPair -> {
            String recordKey = (String)partitionRecordKeyPair.getRight();
            String partitionPath = (String)partitionRecordKeyPair.getLeft();
            return indexFileFilter.getMatchingFilesAndPartition(partitionPath, recordKey).stream().map(partitionFileIdPair -> new ImmutablePair<HoodieFileGroupId, String>(new HoodieFileGroupId((String)partitionFileIdPair.getLeft(), (String)partitionFileIdPair.getRight()), recordKey));
        }).flatMapToPair(BaseStream::iterator);
    }

    protected <R> HoodieData<HoodieRecord<R>> tagLocationBacktoRecords(HoodiePairData<HoodieKey, HoodieRecordLocation> keyFilenamePair, HoodieData<HoodieRecord<R>> records, HoodieTable hoodieTable) {
        HoodiePairData keyRecordPairs = records.mapToPair(record -> new ImmutablePair<HoodieKey, HoodieRecord>(record.getKey(), (HoodieRecord)record));
        return keyRecordPairs.leftOuterJoin(keyFilenamePair).values().map(v -> HoodieIndexUtils.tagAsNewRecordIfNeeded((HoodieRecord)v.getLeft(), Option.ofNullable(((Option)v.getRight()).orElse(null))));
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatusData, HoodieEngineContext context, HoodieTable hoodieTable) {
        return writeStatusData;
    }
}

