/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal.schema.utils;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;

public class InternalSchemaUtils {
    private InternalSchemaUtils() {
    }

    public static InternalSchema pruneInternalSchema(InternalSchema schema, List<String> names) {
        List<Integer> prunedIds = names.stream().map(name2 -> {
            int id = schema.findIdByName((String)name2);
            if (id == -1) {
                throw new IllegalArgumentException(String.format("cannot prune col: %s which does not exist in hudi table", name2));
            }
            return id;
        }).collect(Collectors.toList());
        ArrayList<Integer> topParentFieldIds = new ArrayList<Integer>();
        names.stream().forEach(f -> {
            int id = schema.findIdByName(f.split("\\.")[0]);
            if (!topParentFieldIds.contains(id)) {
                topParentFieldIds.add(id);
            }
        });
        return InternalSchemaUtils.pruneInternalSchemaByID(schema, prunedIds, topParentFieldIds);
    }

    public static InternalSchema pruneInternalSchemaByID(InternalSchema schema, List<Integer> fieldIds, List<Integer> topParentFieldIds) {
        Types.RecordType recordType = (Types.RecordType)InternalSchemaUtils.pruneType(schema.getRecord(), fieldIds);
        ArrayList<Types.Field> newFields = new ArrayList<Types.Field>();
        if (topParentFieldIds != null && !topParentFieldIds.isEmpty()) {
            for (int id : topParentFieldIds) {
                Types.Field f = recordType.field(id);
                if (f != null) {
                    newFields.add(f);
                    continue;
                }
                throw new HoodieSchemaException(String.format("cannot find pruned id %s in currentSchema %s", id, schema));
            }
        }
        return new InternalSchema(newFields.isEmpty() ? recordType : Types.RecordType.get(newFields));
    }

    private static Type pruneType(Type type2, List<Integer> fieldIds) {
        switch (type2.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type2;
                List<Types.Field> fields2 = record.fields();
                ArrayList<Type> newTypes = new ArrayList<Type>();
                for (Types.Field f : fields2) {
                    Type newType = InternalSchemaUtils.pruneType(f.type(), fieldIds);
                    if (fieldIds.contains(f.fieldId())) {
                        newTypes.add(f.type());
                        continue;
                    }
                    newTypes.add(newType);
                }
                boolean changed = false;
                ArrayList<Types.Field> newFields = new ArrayList<Types.Field>();
                for (int i = 0; i < fields2.size(); ++i) {
                    Types.Field oldField = fields2.get(i);
                    Type newType = (Type)newTypes.get(i);
                    if (oldField.type() == newType) {
                        newFields.add(oldField);
                        continue;
                    }
                    if (newType == null) continue;
                    changed = true;
                    newFields.add(Types.Field.get(oldField.fieldId(), oldField.isOptional(), oldField.name(), newType, oldField.doc()));
                }
                if (newFields.isEmpty()) {
                    return null;
                }
                if (newFields.size() == fields2.size() && !changed) {
                    return record;
                }
                return Types.RecordType.get(newFields);
            }
            case ARRAY: {
                Types.ArrayType array = (Types.ArrayType)type2;
                Type newElementType = InternalSchemaUtils.pruneType(array.elementType(), fieldIds);
                if (fieldIds.contains(array.elementId())) {
                    return array;
                }
                if (newElementType != null) {
                    if (array.elementType() == newElementType) {
                        return array;
                    }
                    return Types.ArrayType.get(array.elementId(), array.isElementOptional(), newElementType);
                }
                return null;
            }
            case MAP: {
                Types.MapType map2 = (Types.MapType)type2;
                Type newValueType = InternalSchemaUtils.pruneType(map2.valueType(), fieldIds);
                if (fieldIds.contains(map2.valueId())) {
                    return map2;
                }
                if (newValueType != null) {
                    if (map2.valueType() == newValueType) {
                        return map2;
                    }
                    return Types.MapType.get(map2.keyId(), map2.valueId(), map2.keyType(), newValueType, map2.isValueOptional());
                }
                return null;
            }
        }
        return null;
    }

    public static String reBuildFilterName(String name2, InternalSchema fileSchema, InternalSchema querySchema) {
        int nameId = querySchema.findIdByName(name2);
        if (nameId == -1) {
            throw new IllegalArgumentException(String.format("cannot find filter col name\uff1a%s from querySchema: %s", name2, querySchema));
        }
        if (fileSchema.findField(nameId) == null) {
            return "";
        }
        if (name2.equals(fileSchema.findFullName(nameId))) {
            return name2;
        }
        return fileSchema.findFullName(nameId);
    }

    public static Map<Integer, Pair<Type, Type>> collectTypeChangedCols(InternalSchema schema, InternalSchema oldSchema) {
        Set<Integer> ids = schema.getAllIds();
        Set<Integer> otherIds = oldSchema.getAllIds();
        HashMap<Integer, Pair<Type, Type>> result2 = new HashMap<Integer, Pair<Type, Type>>();
        ids.stream().filter(f -> otherIds.contains(f)).forEach(f -> {
            if (!schema.findType((int)f).equals(oldSchema.findType((int)f))) {
                String[] fieldNameParts = schema.findFullName((int)f).split("\\.");
                String[] otherFieldNameParts = oldSchema.findFullName((int)f).split("\\.");
                String parentName = fieldNameParts[0];
                String otherParentName = otherFieldNameParts[0];
                if (fieldNameParts.length == otherFieldNameParts.length && schema.findIdByName(parentName) == oldSchema.findIdByName(otherParentName)) {
                    int index = schema.findIdByName(parentName);
                    int position = schema.getRecord().fields().stream().map(s -> s.fieldId()).collect(Collectors.toList()).indexOf(index);
                    if (!result2.containsKey(position)) {
                        result2.put(position, Pair.of(schema.findType(parentName), oldSchema.findType(otherParentName)));
                    }
                }
            }
        });
        return result2;
    }

    public static InternalSchema searchSchema(long versionId, List<InternalSchema> internalSchemas) {
        TreeMap<Long, InternalSchema> treeMap = new TreeMap<Long, InternalSchema>();
        internalSchemas.forEach(s -> treeMap.put(s.schemaId(), (InternalSchema)s));
        return InternalSchemaUtils.searchSchema(versionId, treeMap);
    }

    public static InternalSchema searchSchema(long versionId, TreeMap<Long, InternalSchema> treeMap) {
        if (treeMap.containsKey(versionId)) {
            return treeMap.get(versionId);
        }
        SortedMap<Long, InternalSchema> headMap = treeMap.headMap(versionId);
        if (!headMap.isEmpty()) {
            return (InternalSchema)headMap.get(headMap.lastKey());
        }
        return InternalSchema.getEmptyInternalSchema();
    }

    public static String createFullName(String name2, Deque<String> fieldNames) {
        String result2 = name2;
        if (!fieldNames.isEmpty()) {
            ArrayList parentNames = new ArrayList();
            fieldNames.descendingIterator().forEachRemaining(parentNames::add);
            result2 = parentNames.stream().collect(Collectors.joining(".")) + "." + result2;
        }
        return result2;
    }

    public static Map<String, String> collectRenameCols(InternalSchema oldSchema, InternalSchema newSchema) {
        List<String> colNamesFromWriteSchema = oldSchema.getAllColsFullName();
        return colNamesFromWriteSchema.stream().filter(f -> {
            int fieldIdFromWriteSchema = oldSchema.findIdByName((String)f);
            return newSchema.getAllIds().contains(fieldIdFromWriteSchema) && !newSchema.findFullName(fieldIdFromWriteSchema).equalsIgnoreCase((String)f);
        }).collect(Collectors.toMap(e -> newSchema.findFullName(oldSchema.findIdByName((String)e)), e -> {
            int lastDotIndex = e.lastIndexOf(".");
            return e.substring(lastDotIndex == -1 ? 0 : lastDotIndex + 1);
        }));
    }
}

