/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.io.MiniBatchHandle;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkCreateHandle<T, I, K, O>
extends HoodieCreateHandle<T, I, K, O>
implements MiniBatchHandle {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkCreateHandle.class);
    private boolean isClosed = false;

    public FlinkCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, Option.empty(), taskContextSupplier);
    }

    public FlinkCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Option<Schema> schemaOption, TaskContextSupplier taskContextSupplier) {
        super(config, instantTime, hoodieTable, partitionPath, fileId, schemaOption, taskContextSupplier);
        if (this.getAttemptId() > 0L) {
            this.deleteInvalidDataFile(this.getAttemptId() - 1L);
        }
    }

    private void deleteInvalidDataFile(long lastAttemptId) {
        String lastWriteToken = FSUtils.makeWriteToken(this.getPartitionId(), this.getStageId(), lastAttemptId);
        String lastDataFileName = FSUtils.makeBaseFileName(this.instantTime, lastWriteToken, this.fileId, this.hoodieTable.getBaseFileExtension());
        StoragePath path = this.makeNewFilePath(this.partitionPath, lastDataFileName);
        try {
            if (this.storage.exists(path)) {
                LOG.info("Deleting invalid INSERT file due to task retry: " + lastDataFileName);
                this.storage.deleteFile(path);
            }
        }
        catch (IOException e) {
            throw new HoodieException("Error while deleting the INSERT file due to task retry: " + lastDataFileName, e);
        }
    }

    @Override
    protected void createMarkerFile(String partitionPath, String dataFileName) {
        WriteMarkers writeMarkers = WriteMarkersFactory.get(this.config.getMarkersType(), this.hoodieTable, this.instantTime);
        writeMarkers.createIfNotExists(partitionPath, dataFileName, this.getIOType());
    }

    @Override
    public StoragePath makeNewPath(String partitionPath) {
        StoragePath path = super.makeNewPath(partitionPath);
        try {
            int rollNumber = 0;
            while (this.storage.exists(path)) {
                StoragePath existing = path;
                path = this.newFilePathWithRollover(rollNumber++);
                LOG.warn("Duplicate write for INSERT bucket with path: " + existing + ", rolls over to new path: " + path);
            }
            return path;
        }
        catch (IOException e) {
            throw new HoodieException("Checking existing path for create handle error: " + path, e);
        }
    }

    @Override
    public boolean canWrite(HoodieRecord record) {
        return true;
    }

    private StoragePath newFilePathWithRollover(int rollNumber) {
        String dataFileName = FSUtils.makeBaseFileName(this.instantTime, this.writeToken + "-" + rollNumber, this.fileId, this.hoodieTable.getBaseFileExtension());
        return this.makeNewFilePath(this.partitionPath, dataFileName);
    }

    @Override
    public List<WriteStatus> close() {
        try {
            List<WriteStatus> list = super.close();
            return list;
        }
        finally {
            this.isClosed = true;
        }
    }

    @Override
    public void closeGracefully() {
        if (this.isClosed) {
            return;
        }
        try {
            this.close();
        }
        catch (Throwable throwable) {
            LOG.warn("Error while trying to dispose the CREATE handle", throwable);
            try {
                this.storage.deleteFile(this.path);
                LOG.info("Deleting the intermediate CREATE data file: " + this.path + " success!");
            }
            catch (IOException e) {
                LOG.warn("Deleting the intermediate CREATE data file: " + this.path + " failed", (Throwable)e);
            }
        }
    }

    @Override
    public StoragePath getWritePath() {
        return this.path;
    }
}

