/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hudi.io.util.IOUtils;

public class HFileBlockType
extends Enum<HFileBlockType> {
    public static final /* enum */ HFileBlockType DATA = new HFileBlockType("DATABLK*", BlockCategory.DATA);
    public static final /* enum */ HFileBlockType ENCODED_DATA = new HFileBlockType("DATABLKE", BlockCategory.DATA){

        @Override
        public int getId() {
            return DATA.ordinal();
        }
    };
    public static final /* enum */ HFileBlockType LEAF_INDEX = new HFileBlockType("IDXLEAF2", BlockCategory.INDEX);
    public static final /* enum */ HFileBlockType BLOOM_CHUNK = new HFileBlockType("BLMFBLK2", BlockCategory.BLOOM);
    public static final /* enum */ HFileBlockType META = new HFileBlockType("METABLKc", BlockCategory.META);
    public static final /* enum */ HFileBlockType INTERMEDIATE_INDEX = new HFileBlockType("IDXINTE2", BlockCategory.INDEX);
    public static final /* enum */ HFileBlockType ROOT_INDEX = new HFileBlockType("IDXROOT2", BlockCategory.INDEX);
    public static final /* enum */ HFileBlockType FILE_INFO = new HFileBlockType("FILEINF2", BlockCategory.META);
    public static final /* enum */ HFileBlockType GENERAL_BLOOM_META = new HFileBlockType("BLMFMET2", BlockCategory.BLOOM);
    public static final /* enum */ HFileBlockType DELETE_FAMILY_BLOOM_META = new HFileBlockType("DFBLMET2", BlockCategory.BLOOM);
    public static final /* enum */ HFileBlockType TRAILER = new HFileBlockType("TRABLK\"$", BlockCategory.META);
    public static final /* enum */ HFileBlockType INDEX_V1 = new HFileBlockType("IDXBLK)+", BlockCategory.INDEX);
    private final byte[] magic;
    private final BlockCategory metricCat;
    private static final /* synthetic */ HFileBlockType[] $VALUES;

    public static HFileBlockType[] values() {
        return (HFileBlockType[])$VALUES.clone();
    }

    public static HFileBlockType valueOf(String name2) {
        return Enum.valueOf(HFileBlockType.class, name2);
    }

    private HFileBlockType(String magicStr, BlockCategory metricCat) {
        this.magic = magicStr.getBytes(StandardCharsets.UTF_8);
        this.metricCat = metricCat;
        assert (this.magic.length == 8);
    }

    public static HFileBlockType parse(byte[] buf, int offset) throws IOException {
        for (HFileBlockType blockType : HFileBlockType.values()) {
            if (IOUtils.compareTo(blockType.magic, 0, 8, buf, offset, 8) != 0) continue;
            return blockType;
        }
        throw new IOException("Invalid HFile block magic: " + IOUtils.bytesToString(buf, offset, 8));
    }

    public int getId() {
        return this.ordinal();
    }

    public void readAndCheckMagic(DataInputStream in) throws IOException {
        byte[] buf = new byte[8];
        in.readFully(buf);
        if (IOUtils.compareTo(buf, this.magic) != 0) {
            throw new IOException("Invalid magic: expected " + new String(this.magic) + ", got " + new String(buf));
        }
    }

    static {
        $VALUES = new HFileBlockType[]{DATA, ENCODED_DATA, LEAF_INDEX, BLOOM_CHUNK, META, INTERMEDIATE_INDEX, ROOT_INDEX, FILE_INFO, GENERAL_BLOOM_META, DELETE_FAMILY_BLOOM_META, TRAILER, INDEX_V1};
    }

    public static enum BlockCategory {
        DATA,
        META,
        INDEX,
        BLOOM,
        ALL_CATEGORIES,
        UNKNOWN;

    }
}

