/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

public class HoodieFileWriterFactory {
    protected final HoodieStorage storage;

    public HoodieFileWriterFactory(HoodieStorage storage2) {
        this.storage = storage2;
    }

    public static <T, I, K, O> HoodieFileWriter getFileWriter(String instantTime, StoragePath path, HoodieStorage storage2, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier, HoodieRecord.HoodieRecordType recordType) throws IOException {
        String extension = FSUtils.getFileExtension(path.getName());
        HoodieFileWriterFactory factory = HoodieIOFactory.getIOFactory(storage2).getWriterFactory(recordType);
        return factory.getFileWriterByFormat(extension, instantTime, path, config, schema, taskContextSupplier);
    }

    public static <T, I, K, O> HoodieFileWriter getFileWriter(HoodieFileFormat format, OutputStream outputStream, HoodieStorage storage2, HoodieConfig config, Schema schema, HoodieRecord.HoodieRecordType recordType) throws IOException {
        HoodieFileWriterFactory factory = HoodieIOFactory.getIOFactory(storage2).getWriterFactory(recordType);
        return factory.getFileWriterByFormat(format, outputStream, config, schema);
    }

    protected <T, I, K, O> HoodieFileWriter getFileWriterByFormat(String extension, String instantTime, StoragePath path, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
            return this.newParquetFileWriter(instantTime, path, config, schema, taskContextSupplier);
        }
        if (HoodieFileFormat.HFILE.getFileExtension().equals(extension)) {
            return this.newHFileFileWriter(instantTime, path, config, schema, taskContextSupplier);
        }
        if (HoodieFileFormat.ORC.getFileExtension().equals(extension)) {
            return this.newOrcFileWriter(instantTime, path, config, schema, taskContextSupplier);
        }
        throw new UnsupportedOperationException(extension + " format not supported yet.");
    }

    protected <T, I, K, O> HoodieFileWriter getFileWriterByFormat(HoodieFileFormat format, OutputStream outputStream, HoodieConfig config, Schema schema) throws IOException {
        switch (format) {
            case PARQUET: {
                return this.newParquetFileWriter(outputStream, config, schema);
            }
        }
        throw new UnsupportedOperationException((Object)((Object)format) + " format not supported yet.");
    }

    protected HoodieFileWriter newParquetFileWriter(String instantTime, StoragePath path, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected HoodieFileWriter newParquetFileWriter(OutputStream outputStream, HoodieConfig config, Schema schema) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected HoodieFileWriter newHFileFileWriter(String instantTime, StoragePath path, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected HoodieFileWriter newOrcFileWriter(String instantTime, StoragePath path, HoodieConfig config, Schema schema, TaskContextSupplier taskContextSupplier) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static BloomFilter createBloomFilter(HoodieConfig config) {
        return BloomFilterFactory.createBloomFilter(config.getIntOrDefault(HoodieStorageConfig.BLOOM_FILTER_NUM_ENTRIES_VALUE), config.getDoubleOrDefault(HoodieStorageConfig.BLOOM_FILTER_FPP_VALUE), config.getIntOrDefault(HoodieStorageConfig.BLOOM_FILTER_DYNAMIC_MAX_ENTRIES), config.getStringOrDefault(HoodieStorageConfig.BLOOM_FILTER_TYPE));
    }

    public static boolean enableBloomFilter(boolean populateMetaFields, HoodieConfig config) {
        return populateMetaFields && (config.getBooleanOrDefault(HoodieStorageConfig.PARQUET_WITH_BLOOM_FILTER_ENABLED) || config.contains("hoodie.index.type") && config.getString("hoodie.index.type").contains("BLOOM"));
    }
}

