/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.storage.HoodieFileReaderFactory;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

@PublicAPIClass(maturity=ApiMaturityLevel.EVOLVING)
public abstract class HoodieIOFactory {
    protected final HoodieStorage storage;

    public HoodieIOFactory(HoodieStorage storage2) {
        this.storage = storage2;
    }

    public static HoodieIOFactory getIOFactory(HoodieStorage storage2) {
        String ioFactoryClass = storage2.getConf().getString(HoodieStorageConfig.HOODIE_IO_FACTORY_CLASS.key()).orElse(HoodieStorageConfig.HOODIE_IO_FACTORY_CLASS.defaultValue());
        try {
            return (HoodieIOFactory)ReflectionUtils.loadClass(ioFactoryClass, new Class[]{HoodieStorage.class}, new Object[]{storage2});
        }
        catch (Exception e) {
            throw new HoodieException("Unable to create " + ioFactoryClass, e);
        }
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract HoodieFileReaderFactory getReaderFactory(HoodieRecord.HoodieRecordType var1);

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract HoodieFileWriterFactory getWriterFactory(HoodieRecord.HoodieRecordType var1);

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract FileFormatUtils getFileFormatUtils(HoodieFileFormat var1);

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract HoodieStorage getStorage(StoragePath var1);

    @PublicAPIMethod(maturity=ApiMaturityLevel.EVOLVING)
    public abstract HoodieStorage getStorage(StoragePath var1, boolean var2, long var3, int var5, long var6, String var8, ConsistencyGuard var9);

    public final FileFormatUtils getFileFormatUtils(StoragePath path) {
        if (path.getFileExtension().equals(HoodieFileFormat.PARQUET.getFileExtension())) {
            return this.getFileFormatUtils(HoodieFileFormat.PARQUET);
        }
        if (path.getFileExtension().equals(HoodieFileFormat.ORC.getFileExtension())) {
            return this.getFileFormatUtils(HoodieFileFormat.ORC);
        }
        if (path.getFileExtension().equals(HoodieFileFormat.HFILE.getFileExtension())) {
            return this.getFileFormatUtils(HoodieFileFormat.HFILE);
        }
        throw new UnsupportedOperationException("The format for file " + path + " is not supported yet.");
    }
}

