/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordGlobalLocation;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.expression.BindVisitor;
import org.apache.hudi.expression.Expression;
import org.apache.hudi.expression.PartialBindVisitor;
import org.apache.hudi.expression.Predicates;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.metadata.AbstractHoodieTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public class FileSystemBackedTableMetadata
extends AbstractHoodieTableMetadata {
    private static final int DEFAULT_LISTING_PARALLELISM = 1500;
    private final boolean hiveStylePartitioningEnabled;
    private final boolean urlEncodePartitioningEnabled;

    public FileSystemBackedTableMetadata(HoodieEngineContext engineContext, HoodieTableConfig tableConfig, HoodieStorage storage2, String datasetBasePath) {
        super(engineContext, storage2, datasetBasePath);
        this.hiveStylePartitioningEnabled = Boolean.parseBoolean(tableConfig.getHiveStylePartitioningEnable());
        this.urlEncodePartitioningEnabled = Boolean.parseBoolean(tableConfig.getUrlEncodePartitioning());
    }

    public FileSystemBackedTableMetadata(HoodieEngineContext engineContext, HoodieStorage storage2, String datasetBasePath) {
        super(engineContext, storage2, datasetBasePath);
        StoragePath metaPath = new StoragePath(this.dataBasePath, ".hoodie");
        HoodieTableConfig tableConfig = new HoodieTableConfig(storage2, metaPath, null, null, null);
        this.hiveStylePartitioningEnabled = Boolean.parseBoolean(tableConfig.getHiveStylePartitioningEnable());
        this.urlEncodePartitioningEnabled = Boolean.parseBoolean(tableConfig.getUrlEncodePartitioning());
    }

    public HoodieStorage getStorage() {
        if (this.storage == null) {
            this.storage = HoodieStorageUtils.getStorage(this.dataBasePath, this.storageConf);
        }
        return this.storage;
    }

    @Override
    public List<StoragePathInfo> getAllFilesInPartition(StoragePath partitionPath) throws IOException {
        return FSUtils.getAllDataFilesInPartition(this.getStorage(), partitionPath);
    }

    @Override
    public List<String> getAllPartitionPaths() throws IOException {
        return this.getPartitionPathWithPathPrefixes(Collections.singletonList(""));
    }

    @Override
    public List<String> getPartitionPathWithPathPrefixUsingFilterExpression(List<String> relativePathPrefixes, Types.RecordType partitionFields, Expression expression) throws IOException {
        return relativePathPrefixes.stream().flatMap(relativePathPrefix -> {
            try {
                return this.getPartitionPathWithPathPrefixUsingFilterExpression((String)relativePathPrefix, partitionFields, expression).stream();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error fetching partition paths with relative path: " + relativePathPrefix, e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public List<String> getPartitionPathWithPathPrefixes(List<String> relativePathPrefixes) {
        return relativePathPrefixes.stream().flatMap(relativePathPrefix -> {
            try {
                return this.getPartitionPathWithPathPrefix((String)relativePathPrefix).stream();
            }
            catch (IOException e) {
                throw new HoodieIOException("Error fetching partition paths with relative path: " + relativePathPrefix, e);
            }
        }).collect(Collectors.toList());
    }

    private List<String> getPartitionPathWithPathPrefix(String relativePathPrefix) throws IOException {
        return this.getPartitionPathWithPathPrefixUsingFilterExpression(relativePathPrefix, null, null);
    }

    private List<String> getPartitionPathWithPathPrefixUsingFilterExpression(String relativePathPrefix, Types.RecordType partitionFields, Expression pushedExpr) throws IOException {
        Expression fullBoundExpr;
        boolean needPushDownExpressions;
        CopyOnWriteArrayList<StoragePath> pathsToList = new CopyOnWriteArrayList<StoragePath>();
        pathsToList.add(StringUtils.isNullOrEmpty(relativePathPrefix) ? this.dataBasePath : new StoragePath(this.dataBasePath, relativePathPrefix));
        CopyOnWriteArrayList<String> partitionPaths = new CopyOnWriteArrayList<String>();
        int currentPartitionLevel = -1;
        if (this.hiveStylePartitioningEnabled && this.urlEncodePartitioningEnabled && pushedExpr != null && partitionFields != null) {
            currentPartitionLevel = FileSystemBackedTableMetadata.getPathPartitionLevel(partitionFields, relativePathPrefix);
            needPushDownExpressions = true;
            fullBoundExpr = pushedExpr.accept(new BindVisitor(partitionFields, false));
        } else {
            fullBoundExpr = Predicates.alwaysTrue();
            needPushDownExpressions = false;
        }
        while (!pathsToList.isEmpty()) {
            Expression partialBoundExpr;
            int listingParallelism = Math.min(1500, pathsToList.size());
            this.engineContext.setJobStatus(this.getClass().getSimpleName(), "Listing all partitions with prefix " + relativePathPrefix);
            List dirToFileListing = this.engineContext.flatMap(pathsToList, path -> {
                try {
                    return this.getStorage().listDirectEntries((StoragePath)path).stream();
                }
                catch (FileNotFoundException e) {
                    return Stream.empty();
                }
            }, listingParallelism);
            pathsToList.clear();
            int fileListingParallelism = Math.min(1500, dirToFileListing.size());
            if (dirToFileListing.isEmpty()) continue;
            this.engineContext.setJobStatus(this.getClass().getSimpleName(), "Processing listed partitions");
            List<Pair> result2 = this.engineContext.map(dirToFileListing, fileInfo -> {
                StoragePath path = fileInfo.getPath();
                if (fileInfo.isDirectory()) {
                    if (HoodiePartitionMetadata.hasPartitionMetadata(this.getStorage(), path)) {
                        return Pair.of(Option.of(FSUtils.getRelativePartitionPath(this.dataBasePath, path)), Option.empty());
                    }
                    if (!path.getName().equals(".hoodie")) {
                        return Pair.of(Option.empty(), Option.of(path));
                    }
                } else if (path.getName().startsWith(".hoodie_partition_metadata")) {
                    String partitionName = FSUtils.getRelativePartitionPath(this.dataBasePath, path.getParent());
                    return Pair.of(Option.of(partitionName), Option.empty());
                }
                return Pair.of(Option.empty(), Option.empty());
            }, fileListingParallelism);
            partitionPaths.addAll(result2.stream().filter(entry -> ((Option)entry.getKey()).isPresent()).map(entry -> (String)((Option)entry.getKey()).get()).filter(relativePartitionPath -> fullBoundExpr instanceof Predicates.TrueExpression || (Boolean)fullBoundExpr.eval(FileSystemBackedTableMetadata.extractPartitionValues(partitionFields, relativePartitionPath, this.urlEncodePartitioningEnabled)) != false).collect(Collectors.toList()));
            if (needPushDownExpressions && partitionPaths.isEmpty()) {
                Types.RecordType currentSchema = Types.RecordType.get(partitionFields.fields().subList(0, ++currentPartitionLevel));
                PartialBindVisitor partialBindVisitor = new PartialBindVisitor(currentSchema, false);
                partialBoundExpr = pushedExpr.accept(partialBindVisitor);
            } else {
                partialBoundExpr = Predicates.alwaysTrue();
            }
            pathsToList.addAll(result2.stream().filter(entry -> ((Option)entry.getValue()).isPresent()).map(entry -> (StoragePath)((Option)entry.getValue()).get()).filter(path -> partialBoundExpr instanceof Predicates.TrueExpression || (Boolean)partialBoundExpr.eval(FileSystemBackedTableMetadata.extractPartitionValues(partitionFields, FSUtils.getRelativePartitionPath(this.dataBasePath, path), this.urlEncodePartitioningEnabled)) != false).collect(Collectors.toList()));
        }
        return partitionPaths;
    }

    @Override
    public Map<String, List<StoragePathInfo>> getAllFilesInPartitions(Collection<String> partitionPaths) throws IOException {
        if (partitionPaths == null || partitionPaths.isEmpty()) {
            return Collections.emptyMap();
        }
        int parallelism = Math.min(1500, partitionPaths.size());
        this.engineContext.setJobStatus(this.getClass().getSimpleName(), "Listing all files in " + partitionPaths.size() + " partitions");
        List<Pair> partitionToFiles = this.engineContext.map(new ArrayList<String>(partitionPaths), partitionPathStr -> {
            StoragePath partitionPath = new StoragePath((String)partitionPathStr);
            return Pair.of(partitionPathStr, FSUtils.getAllDataFilesInPartition(this.getStorage(), partitionPath));
        }, parallelism);
        return partitionToFiles.stream().collect(Collectors.toMap(pair -> (String)pair.getLeft(), pair -> (List)pair.getRight()));
    }

    @Override
    public Option<String> getSyncedInstantTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Option<String> getLatestCompactionTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void reset() {
    }

    @Override
    public Option<BloomFilter> getBloomFilter(String partitionName, String fileName, String metadataPartitionName) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getBloomFilter for " + fileName);
    }

    @Override
    public Map<Pair<String, String>, BloomFilter> getBloomFilters(List<Pair<String, String>> partitionNameFileNameList, String metadataPartitionName) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getBloomFilters!");
    }

    @Override
    public Map<Pair<String, String>, HoodieMetadataColumnStats> getColumnStats(List<Pair<String, String>> partitionNameFileNameList, String columnName) throws HoodieMetadataException {
        throw new HoodieMetadataException("Unsupported operation: getColumnsStats!");
    }

    @Override
    public HoodieData<HoodieRecord<HoodieMetadataPayload>> getRecordsByKeyPrefixes(List<String> keyPrefixes, String partitionName, boolean shouldLoadInMemory) {
        throw new HoodieMetadataException("Unsupported operation: getRecordsByKeyPrefixes!");
    }

    @Override
    public Map<String, HoodieRecordGlobalLocation> readRecordIndex(List<String> recordKeys) {
        throw new HoodieMetadataException("Unsupported operation: readRecordIndex!");
    }

    @Override
    public Map<String, HoodieRecordGlobalLocation> readSecondaryIndex(List<String> secondaryKeys, String partitionName) {
        throw new HoodieMetadataException("Unsupported operation: readSecondaryIndex!");
    }

    @Override
    public int getNumFileGroupsForPartition(MetadataPartitionType partition) {
        throw new HoodieMetadataException("Unsupported operation: getNumFileGroupsForPartition");
    }

    @Override
    public Map<Pair<String, StoragePath>, List<StoragePathInfo>> listPartitions(List<Pair<String, StoragePath>> partitionPathList) throws IOException {
        HashMap<Pair<String, StoragePath>, List<StoragePathInfo>> pathInfoMap = new HashMap<Pair<String, StoragePath>, List<StoragePathInfo>>();
        for (Pair<String, StoragePath> partitionPair : partitionPathList) {
            StoragePath absolutePartitionPath = partitionPair.getRight();
            try {
                pathInfoMap.put(partitionPair, this.getStorage().listDirectEntries(absolutePartitionPath));
            }
            catch (IOException e) {
                if (!this.getStorage().exists(absolutePartitionPath)) {
                    pathInfoMap.put(partitionPair, Collections.emptyList());
                    continue;
                }
                pathInfoMap.put(partitionPair, this.getStorage().listDirectEntries(absolutePartitionPath));
            }
        }
        return pathInfoMap;
    }
}

