/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.metrics.MetricGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieFlinkMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieFlinkMetrics.class);
    protected Map<String, Long> timers = new HashMap<String, Long>();
    protected final MetricGroup metricGroup;

    protected HoodieFlinkMetrics(MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
    }

    public abstract void registerMetrics();

    protected void startTimer(String name2) {
        if (this.timers.containsKey(name2)) {
            LOG.warn("Restarting timer for name: {}, override the value", (Object)name2);
        }
        this.timers.put(name2, System.currentTimeMillis());
    }

    protected long stopTimer(String name2) {
        if (!this.timers.containsKey(name2)) {
            LOG.warn("Cannot found name {} in timer, potentially caused by inconsistent call", (Object)name2);
            return 0L;
        }
        long costs = System.currentTimeMillis() - this.timers.get(name2);
        this.timers.remove(name2);
        return costs;
    }
}

