/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.MetricRegistry;
import java.util.Properties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.ConsoleMetricsReporter;
import org.apache.hudi.metrics.InMemoryMetricsReporter;
import org.apache.hudi.metrics.JmxMetricsReporter;
import org.apache.hudi.metrics.MetricsGraphiteReporter;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.Slf4jMetricsReporter;
import org.apache.hudi.metrics.custom.CustomizableMetricsReporter;
import org.apache.hudi.metrics.datadog.DatadogMetricsReporter;
import org.apache.hudi.metrics.m3.M3MetricsReporter;
import org.apache.hudi.metrics.prometheus.PrometheusReporter;
import org.apache.hudi.metrics.prometheus.PushGatewayMetricsReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsReporterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsReporterFactory.class);

    public static Option<MetricsReporter> createReporter(HoodieMetricsConfig metricsConfig, MetricRegistry registry) {
        String reporterClassName = metricsConfig.getMetricReporterClassName();
        if (!StringUtils.isNullOrEmpty(reporterClassName)) {
            Object instance = ReflectionUtils.loadClass(reporterClassName, new Class[]{Properties.class, MetricRegistry.class}, new Object[]{metricsConfig.getProps(), registry});
            if (!(instance instanceof CustomizableMetricsReporter)) {
                throw new HoodieException(metricsConfig.getMetricReporterClassName() + " is not a subclass of CustomizableMetricsReporter");
            }
            return Option.of((MetricsReporter)instance);
        }
        MetricsReporterType type2 = metricsConfig.getMetricsReporterType();
        MetricsReporter reporter2 = null;
        if (type2 == null) {
            LOG.warn(String.format("Metric creation failed. %s is not configured", HoodieMetricsConfig.METRICS_REPORTER_TYPE_VALUE.key()));
            return Option.empty();
        }
        switch (type2) {
            case GRAPHITE: {
                reporter2 = new MetricsGraphiteReporter(metricsConfig, registry);
                break;
            }
            case INMEMORY: {
                reporter2 = new InMemoryMetricsReporter();
                break;
            }
            case JMX: {
                reporter2 = new JmxMetricsReporter(metricsConfig, registry);
                break;
            }
            case DATADOG: {
                reporter2 = new DatadogMetricsReporter(metricsConfig, registry);
                break;
            }
            case PROMETHEUS_PUSHGATEWAY: {
                reporter2 = new PushGatewayMetricsReporter(metricsConfig, registry);
                break;
            }
            case PROMETHEUS: {
                reporter2 = new PrometheusReporter(metricsConfig, registry);
                break;
            }
            case CONSOLE: {
                reporter2 = new ConsoleMetricsReporter(registry);
                break;
            }
            case CLOUDWATCH: {
                reporter2 = (MetricsReporter)ReflectionUtils.loadClass("org.apache.hudi.aws.metrics.cloudwatch.CloudWatchMetricsReporter", new Class[]{HoodieMetricsConfig.class, MetricRegistry.class}, new Object[]{metricsConfig, registry});
                break;
            }
            case M3: {
                reporter2 = new M3MetricsReporter(metricsConfig, registry);
                break;
            }
            case SLF4J: {
                reporter2 = new Slf4jMetricsReporter(registry);
                break;
            }
            default: {
                LOG.error("Reporter type[" + (Object)((Object)type2) + "] is not supported.");
            }
        }
        return Option.ofNullable(reporter2);
    }
}

