/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.PushGateway;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metrics.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushGatewayReporter
extends ScheduledReporter {
    private static final Logger LOG = LoggerFactory.getLogger(PushGatewayReporter.class);
    private static final Map<String, PushGateway> PUSH_GATEWAY_PER_HOSTNAME = new ConcurrentHashMap<String, PushGateway>();
    private final PushGateway pushGatewayClient;
    private final DropwizardExports metricExports;
    private final CollectorRegistry collectorRegistry;
    private final String jobName;
    private final Map<String, String> labels;
    private final boolean deleteShutdown;
    private final HashMap<String, io.prometheus.client.Gauge> gaugeHashMap;
    private final MetricRegistry registry;

    protected PushGatewayReporter(MetricRegistry registry, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, String jobName, Map<String, String> labels, String serverHost, int serverPort, boolean deleteShutdown) {
        super(registry, "hudi-push-gateway-reporter", filter, rateUnit, durationUnit);
        this.jobName = jobName;
        this.labels = labels;
        this.deleteShutdown = deleteShutdown;
        this.registry = registry;
        this.collectorRegistry = new CollectorRegistry();
        this.metricExports = new DropwizardExports(registry);
        this.pushGatewayClient = this.createPushGatewayClient(serverHost, serverPort);
        this.metricExports.register(this.collectorRegistry);
        this.gaugeHashMap = new HashMap();
    }

    private synchronized PushGateway createPushGatewayClient(String serverHost, int serverPort) {
        PushGateway pushGateway;
        String serverUrl = String.format("%s:%s", serverHost, serverPort);
        if (PUSH_GATEWAY_PER_HOSTNAME.containsKey(serverUrl)) {
            return PUSH_GATEWAY_PER_HOSTNAME.get(serverUrl);
        }
        if (serverPort == 443) {
            try {
                pushGateway = new PushGateway(new URL("https://" + serverUrl));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Malformed pushgateway host: " + serverHost);
            }
        } else {
            pushGateway = new PushGateway(serverUrl);
        }
        PUSH_GATEWAY_PER_HOSTNAME.put(serverUrl, pushGateway);
        return pushGateway;
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            this.handleLabeledMetrics();
            this.pushGatewayClient.pushAdd(this.collectorRegistry, this.jobName, this.labels);
        }
        catch (IOException e) {
            LOG.warn("Can't push monitoring information to pushGateway", (Throwable)e);
        }
    }

    @Override
    public void start(long period, TimeUnit unit) {
        super.start(period, unit);
    }

    @Override
    public void stop() {
        super.stop();
        try {
            if (this.deleteShutdown) {
                this.collectorRegistry.unregister((Collector)this.metricExports);
                this.pushGatewayClient.delete(this.jobName, this.labels);
                for (String key : this.gaugeHashMap.keySet()) {
                    Pair<String, Map<String, String>> mapPair = MetricUtils.getLabelsAndMetricMap(key);
                    this.pushGatewayClient.delete(mapPair.getKey(), mapPair.getValue());
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to delete metrics from pushGateway with jobName {" + this.jobName + "}", (Throwable)e);
        }
    }

    private void handleLabeledMetrics() {
        this.registry.getGauges().entrySet().forEach(gaugeEntry -> {
            String key = (String)gaugeEntry.getKey();
            Pair<String, Map<String, String>> stringMapPair = MetricUtils.getLabelsAndMetricMap(key);
            if (stringMapPair.getValue().size() > 0) {
                ArrayList<String> labelNames = new ArrayList<String>();
                ArrayList<String> labelValues = new ArrayList<String>();
                for (Map.Entry<String, String> et : stringMapPair.getValue().entrySet()) {
                    labelNames.add(et.getKey());
                    labelValues.add(et.getValue());
                }
                if (!this.gaugeHashMap.containsKey(key)) {
                    this.gaugeHashMap.put(key, (io.prometheus.client.Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)io.prometheus.client.Gauge.build().help("labeled metricName:" + stringMapPair.getKey())).name(stringMapPair.getKey())).labelNames(labelNames.toArray(new String[0]))).register(this.collectorRegistry));
                }
                ((Gauge.Child)this.gaugeHashMap.get(key).labels(labelValues.toArray(new String[0]))).set((double)((Long)((Gauge)gaugeEntry.getValue()).getValue()).longValue());
            }
        });
    }
}

