/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.compact;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.sink.compact.CompactionPlanEvent;
import org.apache.hudi.util.StreamerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionPlanSourceFunction
extends AbstractRichFunction
implements SourceFunction<CompactionPlanEvent> {
    protected static final Logger LOG = LoggerFactory.getLogger(CompactionPlanSourceFunction.class);
    private final List<Pair<String, HoodieCompactionPlan>> compactionPlans;
    private final Configuration conf;

    public CompactionPlanSourceFunction(List<Pair<String, HoodieCompactionPlan>> compactionPlans, Configuration conf) {
        this.compactionPlans = compactionPlans;
        this.conf = conf;
    }

    @Override
    public void open(Configuration parameters2) throws Exception {
    }

    public void run(SourceFunction.SourceContext sourceContext) throws Exception {
        HoodieTimeline pendingCompactionTimeline = StreamerUtil.createMetaClient(this.conf).getActiveTimeline().filterPendingCompactionTimeline();
        for (Pair<String, HoodieCompactionPlan> pair : this.compactionPlans) {
            if (!pendingCompactionTimeline.containsInstant(pair.getLeft())) {
                LOG.warn(pair.getLeft() + " not found in pending compaction instants.");
                continue;
            }
            HoodieCompactionPlan compactionPlan = pair.getRight();
            List operations = compactionPlan.getOperations().stream().map(CompactionOperation::convertFromAvroRecordInstance).collect(Collectors.toList());
            LOG.info("CompactionPlanFunction compacting " + operations + " files");
            for (CompactionOperation operation : operations) {
                sourceContext.collect((Object)new CompactionPlanEvent(pair.getLeft(), operation));
            }
        }
    }

    @Override
    public void close() throws Exception {
    }

    public void cancel() {
    }
}

