/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.source.prune;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.hudi.source.ExpressionEvaluators;
import org.apache.hudi.source.stats.ColumnStats;
import org.apache.hudi.util.ExpressionUtils;

public class ColumnStatsProbe
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String[] referencedCols;
    private final List<ExpressionEvaluators.Evaluator> evaluators;

    private ColumnStatsProbe(String[] referencedCols, List<ExpressionEvaluators.Evaluator> evaluators) {
        this.referencedCols = referencedCols;
        this.evaluators = evaluators;
    }

    public boolean test(RowData indexRow, RowType.RowField[] queryFields) {
        Map<String, ColumnStats> columnStatsMap = ColumnStatsProbe.convertColumnStats(indexRow, queryFields);
        for (ExpressionEvaluators.Evaluator evaluator : this.evaluators) {
            if (evaluator.eval(columnStatsMap)) continue;
            return false;
        }
        return true;
    }

    public String[] getReferencedCols() {
        return this.referencedCols;
    }

    @Nullable
    public static ColumnStatsProbe newInstance(List<ResolvedExpression> filters) {
        if (filters.isEmpty()) {
            return null;
        }
        String[] referencedCols = ExpressionUtils.referencedColumns(filters);
        if (referencedCols.length == 0) {
            return null;
        }
        List<ExpressionEvaluators.Evaluator> evaluators = ExpressionEvaluators.fromExpression(filters);
        return new ColumnStatsProbe(referencedCols, evaluators);
    }

    public static Map<String, ColumnStats> convertColumnStats(RowData indexRow, RowType.RowField[] queryFields) {
        if (indexRow == null || queryFields == null) {
            throw new IllegalArgumentException("Index Row and query fields could not be null.");
        }
        LinkedHashMap<String, ColumnStats> mapping = new LinkedHashMap<String, ColumnStats>();
        for (int i = 0; i < queryFields.length; ++i) {
            String name2 = queryFields[i].getName();
            int startPos = 2 + i * 3;
            LogicalType colType = queryFields[i].getType();
            Object minVal = indexRow.isNullAt(startPos) ? null : ColumnStatsProbe.getValAsJavaObj(indexRow, startPos, colType);
            Object maxVal = indexRow.isNullAt(startPos + 1) ? null : ColumnStatsProbe.getValAsJavaObj(indexRow, startPos + 1, colType);
            long nullCnt = indexRow.getLong(startPos + 2);
            mapping.put(name2, new ColumnStats(minVal, maxVal, nullCnt));
        }
        return mapping;
    }

    private static Object getValAsJavaObj(RowData indexRow, int pos, LogicalType colType) {
        switch (colType.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                TimestampType tsType = (TimestampType)colType;
                return indexRow.getTimestamp(pos, tsType.getPrecision()).getMillisecond();
            }
            case TIME_WITHOUT_TIME_ZONE: 
            case DATE: 
            case BIGINT: {
                return indexRow.getLong(pos);
            }
            case BOOLEAN: {
                return indexRow.getBoolean(pos);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: {
                return indexRow.getInt(pos);
            }
            case FLOAT: {
                return Float.valueOf(indexRow.getFloat(pos));
            }
            case DOUBLE: {
                return indexRow.getDouble(pos);
            }
            case BINARY: 
            case VARBINARY: {
                return indexRow.getBinary(pos);
            }
            case CHAR: 
            case VARCHAR: {
                return indexRow.getString(pos).toString();
            }
            case DECIMAL: {
                DecimalType decimalType = (DecimalType)colType;
                return indexRow.getDecimal(pos, decimalType.getPrecision(), decimalType.getScale()).toBigDecimal();
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + colType);
    }
}

