/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.model;

import java.util.Objects;
import org.apache.hudi.common.util.Option;

public class FieldSchema {
    private final String name;
    private String type;
    private Option<String> comment;

    public FieldSchema(String name2, String type2) {
        this(name2, type2, Option.empty());
    }

    public FieldSchema(String name2, String type2, String comment) {
        this(name2, type2, Option.ofNullable(comment));
    }

    public FieldSchema(String name2, String type2, Option<String> comment) {
        this.name = name2;
        this.type = type2;
        this.comment = comment;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Option<String> getComment() {
        return this.comment;
    }

    public String getCommentOrEmpty() {
        return this.comment.orElse("");
    }

    public void setType(String type2) {
        this.type = type2;
    }

    public void setComment(Option<String> comment) {
        this.comment = comment;
    }

    public void setComment(String comment) {
        this.comment = Option.ofNullable(comment);
    }

    public boolean updateComment(FieldSchema another) {
        if (Objects.equals(this.name, another.getName()) && !Objects.equals(this.getCommentOrEmpty(), another.getCommentOrEmpty())) {
            this.setComment(another.getComment());
            return true;
        }
        return false;
    }
}

