/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.util;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieMetaSyncException;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncUtilHelpers {
    private static final Logger LOG = LoggerFactory.getLogger(SyncUtilHelpers.class);
    private static final ConcurrentHashMap<String, Lock> TABLE_LOCKS = new ConcurrentHashMap();

    public static void runHoodieMetaSync(String syncToolClassName, TypedProperties props, Configuration hadoopConfig, FileSystem fs, String targetBasePath, String baseFileFormat) {
        SyncUtilHelpers.runHoodieMetaSync(syncToolClassName, props, hadoopConfig, fs, targetBasePath, baseFileFormat, Option.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runHoodieMetaSync(String syncToolClassName, TypedProperties props, Configuration hadoopConfig, FileSystem fs, String targetBasePath, String baseFileFormat, Option<HoodieTableMetaClient> metaClient) {
        if (targetBasePath == null) {
            throw new IllegalArgumentException("Target base path must not be null");
        }
        Lock tableLock = TABLE_LOCKS.computeIfAbsent(targetBasePath, k -> new ReentrantLock());
        tableLock.lock();
        try {
            try (HoodieSyncTool syncTool = SyncUtilHelpers.instantiateMetaSyncTool(syncToolClassName, props, hadoopConfig, fs, targetBasePath, baseFileFormat, metaClient);){
                syncTool.syncHoodieTable();
            }
            catch (Throwable e) {
                throw new HoodieMetaSyncException("Could not sync using the meta sync class " + syncToolClassName, e);
            }
        }
        finally {
            tableLock.unlock();
        }
    }

    public static HoodieSyncTool instantiateMetaSyncTool(String syncToolClassName, TypedProperties props, Configuration hadoopConfig, FileSystem fs, String targetBasePath, String baseFileFormat, Option<HoodieTableMetaClient> metaClient) {
        String tableName;
        TypedProperties properties2 = new TypedProperties();
        properties2.putAll((Map<?, ?>)props);
        properties2.put(HoodieCommonConfig.BASE_PATH.key(), targetBasePath);
        properties2.put(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), targetBasePath);
        properties2.put(HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT.key(), baseFileFormat);
        if (properties2.containsKey(HoodieSyncConfig.META_SYNC_TABLE_NAME.key()) && !(tableName = properties2.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME.key())).equals(tableName.toLowerCase())) {
            LOG.warn("Table name \"{}\" contains capital letters. Your metastore may automatically convert this to lower case and can cause table not found errors during subsequent syncs.", (Object)tableName);
        }
        if (ReflectionUtils.hasConstructor(syncToolClassName, new Class[]{Properties.class, Configuration.class, Option.class})) {
            return (HoodieSyncTool)ReflectionUtils.loadClass(syncToolClassName, new Class[]{Properties.class, Configuration.class, Option.class}, new Object[]{properties2, hadoopConfig, metaClient});
        }
        if (ReflectionUtils.hasConstructor(syncToolClassName, new Class[]{Properties.class, Configuration.class})) {
            return (HoodieSyncTool)ReflectionUtils.loadClass(syncToolClassName, new Class[]{Properties.class, Configuration.class}, new Object[]{properties2, hadoopConfig});
        }
        if (ReflectionUtils.hasConstructor(syncToolClassName, new Class[]{Properties.class})) {
            return (HoodieSyncTool)ReflectionUtils.loadClass(syncToolClassName, new Class[]{Properties.class}, new Object[]{properties2});
        }
        if (ReflectionUtils.hasConstructor(syncToolClassName, new Class[]{TypedProperties.class, Configuration.class, FileSystem.class})) {
            return (HoodieSyncTool)ReflectionUtils.loadClass(syncToolClassName, new Class[]{TypedProperties.class, Configuration.class, FileSystem.class}, new Object[]{properties2, hadoopConfig, fs});
        }
        if (ReflectionUtils.hasConstructor(syncToolClassName, new Class[]{Properties.class, FileSystem.class})) {
            return (HoodieSyncTool)ReflectionUtils.loadClass(syncToolClassName, new Class[]{Properties.class, FileSystem.class}, new Object[]{properties2, fs});
        }
        throw new HoodieException("Could not load meta sync class " + syncToolClassName + ": no valid constructor found.");
    }

    public static HoodieException getHoodieMetaSyncException(Map<String, HoodieException> failedMetaSyncs) {
        if (failedMetaSyncs.size() == 1) {
            return failedMetaSyncs.values().stream().findFirst().get();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("MetaSyncs failed: {");
        sb.append(String.join((CharSequence)",", failedMetaSyncs.keySet()));
        sb.append("}\n");
        for (String impl : failedMetaSyncs.keySet()) {
            sb.append(failedMetaSyncs.get(impl).getMessage());
            sb.append("\n");
        }
        return new HoodieMetaSyncException(sb.toString(), failedMetaSyncs);
    }

    static int getNumberOfLocks() {
        return TABLE_LOCKS.size();
    }
}

