/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieFlinkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.FlinkHoodieIndexFactory;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.metadata.FlinkHoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.table.ExplicitWriteHandleTable;
import org.apache.hudi.table.HoodieFlinkCopyOnWriteTable;
import org.apache.hudi.table.HoodieFlinkMergeOnReadTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;

public abstract class HoodieFlinkTable<T>
extends HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>>
implements ExplicitWriteHandleTable<T> {
    protected HoodieFlinkTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    public static <T> HoodieFlinkTable<T> create(HoodieWriteConfig config, HoodieEngineContext context) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(context.getStorageConf().newInstance()).setBasePath(config.getBasePath()).setLoadActiveTimelineOnLoad(true).setConsistencyGuardConfig(config.getConsistencyGuardConfig()).setTimeGeneratorConfig(config.getTimeGeneratorConfig()).setFileSystemRetryConfig(config.getFileSystemRetryConfig()).build();
        return HoodieFlinkTable.create(config, context, metaClient);
    }

    public static <T> HoodieFlinkTable<T> create(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        HoodieFlinkCopyOnWriteTable hoodieFlinkTable;
        if (config.getSchemaEvolutionEnable()) {
            HoodieFlinkTable.setLatestInternalSchema(config, metaClient);
        }
        switch (metaClient.getTableType()) {
            case COPY_ON_WRITE: {
                hoodieFlinkTable = new HoodieFlinkCopyOnWriteTable(config, context, metaClient);
                break;
            }
            case MERGE_ON_READ: {
                hoodieFlinkTable = new HoodieFlinkMergeOnReadTable(config, context, metaClient);
                break;
            }
            default: {
                throw new HoodieException("Unsupported table type :" + (Object)((Object)metaClient.getTableType()));
            }
        }
        return hoodieFlinkTable;
    }

    public static HoodieWriteMetadata<List<WriteStatus>> convertMetadata(HoodieWriteMetadata<HoodieData<WriteStatus>> metadata2) {
        return metadata2.clone(metadata2.getWriteStatuses().collectAsList());
    }

    @Override
    protected HoodieIndex getIndex(HoodieWriteConfig config, HoodieEngineContext context) {
        return FlinkHoodieIndexFactory.createIndex((HoodieFlinkEngineContext)context, config);
    }

    @Override
    protected Option<HoodieTableMetadataWriter> getMetadataWriter(String triggeringInstantTimestamp, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy) {
        if (this.config.isMetadataTableEnabled() || this.getMetaClient().getTableConfig().isMetadataTableAvailable()) {
            return Option.of(FlinkHoodieBackedTableMetadataWriter.create(this.getContext().getStorageConf(), this.config, failedWritesCleaningPolicy, this.getContext(), Option.of(triggeringInstantTimestamp)));
        }
        return Option.empty();
    }

    private static void setLatestInternalSchema(HoodieWriteConfig config, HoodieTableMetaClient metaClient) {
        Option<InternalSchema> internalSchema = new TableSchemaResolver(metaClient).getTableInternalSchemaFromCommitMetadata();
        if (internalSchema.isPresent()) {
            config.setInternalSchemaString(SerDeHelper.toJson(internalSchema.get()));
        }
    }
}

