/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.execution.FlinkLazyInsertIterable;
import org.apache.hudi.io.ExplicitWriteHandleFactory;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseCommitActionExecutor;
import org.apache.hudi.table.action.commit.BucketType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFlinkCommitActionExecutor<T>
extends BaseCommitActionExecutor<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>, HoodieWriteMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseFlinkCommitActionExecutor.class);
    protected HoodieWriteHandle<?, ?, ?, ?> writeHandle;

    public BaseFlinkCommitActionExecutor(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, HoodieWriteConfig config, HoodieTable table, String instantTime, WriteOperationType operationType) {
        this(context, writeHandle, config, table, instantTime, operationType, Option.empty());
    }

    public BaseFlinkCommitActionExecutor(HoodieEngineContext context, HoodieWriteHandle<?, ?, ?, ?> writeHandle, HoodieWriteConfig config, HoodieTable table, String instantTime, WriteOperationType operationType, Option extraMetadata) {
        super(context, config, table, instantTime, operationType, extraMetadata);
        this.writeHandle = writeHandle;
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> execute(List<HoodieRecord<T>> inputRecords) {
        return this.execute(inputRecords, Option.empty());
    }

    @Override
    public HoodieWriteMetadata<List<WriteStatus>> execute(List<HoodieRecord<T>> inputRecords, Option<HoodieTimer> sourceReadAndIndexTimer) {
        HoodieWriteMetadata<List<WriteStatus>> result2 = new HoodieWriteMetadata<List<WriteStatus>>();
        LinkedList<WriteStatus> writeStatuses = new LinkedList<WriteStatus>();
        HoodieRecord<T> record = inputRecords.get(0);
        String partitionPath = record.getPartitionPath();
        String fileId = record.getCurrentLocation().getFileId();
        BucketType bucketType = record.getCurrentLocation().getInstantTime().equals("I") ? BucketType.INSERT : BucketType.UPDATE;
        this.handleUpsertPartition(partitionPath, fileId, bucketType, inputRecords.iterator()).forEachRemaining(writeStatuses::addAll);
        this.setUpWriteMetadata(writeStatuses, result2);
        return result2;
    }

    protected void setUpWriteMetadata(List<WriteStatus> statuses, HoodieWriteMetadata<List<WriteStatus>> result2) {
        result2.setWriteStatuses(statuses);
        result2.setIndexUpdateDuration(Duration.ZERO);
    }

    @Override
    protected String getCommitActionType() {
        return this.table.getMetaClient().getCommitActionType();
    }

    @Override
    protected void commit(HoodieWriteMetadata<List<WriteStatus>> result2) {
        this.commit(result2, result2.getWriteStatuses().stream().map(WriteStatus::getStat).collect(Collectors.toList()));
    }

    @Override
    protected void setCommitMetadata(HoodieWriteMetadata<List<WriteStatus>> result2) {
        result2.setCommitMetadata(Option.of(CommitUtils.buildMetadata(result2.getWriteStatuses().stream().map(WriteStatus::getStat).collect(Collectors.toList()), result2.getPartitionToReplaceFileIds(), this.extraMetadata, this.operationType, this.getSchemaToStoreInCommit(), this.getCommitActionType())));
    }

    protected Iterator<List<WriteStatus>> handleUpsertPartition(String partitionPath, String fileIdHint, BucketType bucketType, Iterator recordItr) {
        try {
            if (this.writeHandle instanceof HoodieCreateHandle) {
                return this.handleInsert(fileIdHint, recordItr);
            }
            if (this.writeHandle instanceof HoodieMergeHandle) {
                return this.handleUpdate(partitionPath, fileIdHint, recordItr);
            }
            switch (bucketType) {
                case INSERT: {
                    return this.handleInsert(fileIdHint, recordItr);
                }
                case UPDATE: {
                    return this.handleUpdate(partitionPath, fileIdHint, recordItr);
                }
            }
            throw new AssertionError();
        }
        catch (Throwable t) {
            String msg = "Error upserting bucketType " + (Object)((Object)bucketType) + " for partition :" + partitionPath;
            LOG.error(msg, t);
            throw new HoodieUpsertException(msg, t);
        }
    }

    @Override
    public Iterator<List<WriteStatus>> handleUpdate(String partitionPath, String fileId, Iterator<HoodieRecord<T>> recordItr) throws IOException {
        if (!recordItr.hasNext()) {
            LOG.info("Empty partition with fileId => " + fileId);
            return Collections.singletonList(Collections.EMPTY_LIST).iterator();
        }
        HoodieMergeHandle upsertHandle = (HoodieMergeHandle)this.writeHandle;
        return this.handleUpdateInternal(upsertHandle, fileId);
    }

    protected Iterator<List<WriteStatus>> handleUpdateInternal(HoodieMergeHandle<?, ?, ?, ?> upsertHandle, String fileId) throws IOException {
        this.table.runMerge(upsertHandle, this.instantTime, fileId);
        return upsertHandle.getWriteStatusesAsIterator();
    }

    @Override
    public Iterator<List<WriteStatus>> handleInsert(String idPfx, Iterator<HoodieRecord<T>> recordItr) throws Exception {
        if (!recordItr.hasNext()) {
            LOG.info("Empty partition");
            return Collections.singletonList(Collections.EMPTY_LIST).iterator();
        }
        return new FlinkLazyInsertIterable<T>(recordItr, true, this.config, this.instantTime, this.table, idPfx, this.taskContextSupplier, new ExplicitWriteHandleFactory(this.writeHandle));
    }

    @Override
    protected void updateColumnsToIndexForColumnStats(HoodieTableMetaClient metaClient, List<String> columnsToIndex) {
    }
}

