/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BaseWriteHelper;

public class JavaWriteHelper<T, R>
extends BaseWriteHelper<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>, R> {
    private JavaWriteHelper() {
        super((I ignored) -> -1);
    }

    public static JavaWriteHelper newInstance() {
        return WriteHelperHolder.JAVA_WRITE_HELPER;
    }

    @Override
    protected List<HoodieRecord<T>> tag(List<HoodieRecord<T>> dedupedRecords, HoodieEngineContext context, HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> table) {
        return table.getIndex().tagLocation(HoodieListData.eager(dedupedRecords), context, (HoodieTable)table).collectAsList();
    }

    @Override
    public List<HoodieRecord<T>> deduplicateRecords(List<HoodieRecord<T>> records, HoodieIndex<?, ?> index, int parallelism, String schemaStr, TypedProperties props, HoodieRecordMerger merger) {
        boolean isIndexingGlobal = index.isGlobal();
        Map<Object, List<Pair>> keyedRecords = records.stream().map(record -> {
            HoodieKey hoodieKey = record.getKey();
            Object key = isIndexingGlobal ? hoodieKey.getRecordKey() : hoodieKey;
            return Pair.of(key, record);
        }).collect(Collectors.groupingBy(Pair::getLeft));
        Schema schema = new Schema.Parser().parse(schemaStr);
        return keyedRecords.values().stream().map(x -> x.stream().map(Pair::getRight).reduce((rec1, rec2) -> {
            HoodieRecord reducedRecord;
            try {
                reducedRecord = merger.merge((HoodieRecord)rec1, schema, (HoodieRecord)rec2, schema, props).get().getLeft();
            }
            catch (IOException e) {
                throw new HoodieException(String.format("Error to merge two records, %s, %s", rec1, rec2), e);
            }
            return reducedRecord.newInstance(rec1.getKey(), rec1.getOperation());
        }).orElse(null)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static class WriteHelperHolder {
        private static final JavaWriteHelper JAVA_WRITE_HELPER = new JavaWriteHelper();

        private WriteHelperHolder() {
        }
    }
}

