/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.savepoint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavepointActionExecutor<T, I, K, O>
extends BaseActionExecutor<T, I, K, O, HoodieSavepointMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(SavepointActionExecutor.class);
    private final String user;
    private final String comment;

    public SavepointActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String user, String comment) {
        super(context, config, table, instantTime);
        this.user = user;
        this.comment = comment;
    }

    @Override
    public HoodieSavepointMetadata execute() {
        if (!this.table.getCompletedCommitsTimeline().containsInstant(this.instantTime)) {
            throw new HoodieSavepointException("Could not savepoint non-existing commit " + this.instantTime);
        }
        try {
            Map<String, List<String>> latestFilesMap;
            Option<HoodieInstant> cleanInstant = this.table.getCleanTimeline().lastInstant();
            String lastCommitRetained = cleanInstant.map(instant -> {
                try {
                    if (instant.isCompleted()) {
                        return this.table.getActiveTimeline().readCleanMetadata((HoodieInstant)instant).getEarliestCommitToRetain();
                    }
                    return this.table.getActiveTimeline().readCleanerPlan(this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, instant.getAction(), instant.requestedTime())).getEarliestInstantToRetain().getTimestamp();
                }
                catch (IOException e) {
                    throw new HoodieSavepointException("Failed to savepoint " + this.instantTime, e);
                }
            }).orElseGet(() -> this.table.getCompletedCommitsTimeline().firstInstant().get().requestedTime());
            ValidationUtils.checkArgument(InstantComparison.compareTimestamps(this.instantTime, InstantComparison.GREATER_THAN_OR_EQUALS, lastCommitRetained), "Could not savepoint commit " + this.instantTime + " as this is beyond the lookup window " + lastCommitRetained);
            this.context.setJobStatus(this.getClass().getSimpleName(), "Collecting latest files for savepoint " + this.instantTime + " " + this.table.getConfig().getTableName());
            TableFileSystemView.SliceView view = this.table.getSliceView();
            if (this.table.getMetaClient().getTableConfig().isMetadataTableAvailable()) {
                latestFilesMap = view.getAllLatestFileSlicesBeforeOrOn(this.instantTime).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                    ArrayList latestFiles = new ArrayList();
                    ((Stream)entry.getValue()).forEach(fileSlice -> {
                        if (fileSlice.getBaseFile().isPresent()) {
                            latestFiles.add(fileSlice.getBaseFile().get().getFileName());
                        }
                        latestFiles.addAll(fileSlice.getLogFiles().map(HoodieLogFile::getFileName).collect(Collectors.toList()));
                    });
                    return latestFiles;
                }));
            } else {
                List<String> partitions = FSUtils.getAllPartitionPaths(this.context, this.table.getStorage(), this.config.getMetadataConfig(), this.table.getMetaClient().getBasePath());
                latestFilesMap = this.context.mapToPair(partitions, partitionPath -> {
                    LOG.info("Collecting latest files in partition path " + partitionPath);
                    ArrayList latestFiles = new ArrayList();
                    view.getLatestFileSlicesBeforeOrOn((String)partitionPath, this.instantTime, true).forEach(fileSlice -> {
                        if (fileSlice.getBaseFile().isPresent()) {
                            latestFiles.add(fileSlice.getBaseFile().get().getFileName());
                        }
                        latestFiles.addAll(fileSlice.getLogFiles().map(HoodieLogFile::getFileName).collect(Collectors.toList()));
                    });
                    return new ImmutablePair((String)partitionPath, latestFiles);
                }, null);
            }
            HoodieSavepointMetadata metadata2 = TimelineMetadataUtils.convertSavepointMetadata(this.user, this.comment, latestFilesMap);
            this.table.getActiveTimeline().createNewInstant(this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "savepoint", this.instantTime));
            this.table.getActiveTimeline().saveAsComplete(this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "savepoint", this.instantTime), Option.of(metadata2));
            LOG.info("Savepoint " + this.instantTime + " created");
            return metadata2;
        }
        catch (HoodieIOException e) {
            throw new HoodieSavepointException("Failed to savepoint " + this.instantTime, e);
        }
    }
}

