/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.catalog;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeVisitor;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.NullType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class TypeInfoLogicalTypeVisitor
extends LogicalTypeDefaultVisitor<TypeInfo> {
    private final LogicalType type;

    TypeInfoLogicalTypeVisitor(DataType dataType) {
        this(dataType.getLogicalType());
    }

    TypeInfoLogicalTypeVisitor(LogicalType type2) {
        this.type = type2;
    }

    public TypeInfo visit(CharType charType) {
        return TypeInfoFactory.stringTypeInfo;
    }

    public TypeInfo visit(VarCharType varCharType) {
        return TypeInfoFactory.stringTypeInfo;
    }

    public TypeInfo visit(BooleanType booleanType) {
        return TypeInfoFactory.booleanTypeInfo;
    }

    public TypeInfo visit(VarBinaryType varBinaryType) {
        if (varBinaryType.getLength() == Integer.MAX_VALUE) {
            return TypeInfoFactory.binaryTypeInfo;
        }
        return this.defaultMethod((LogicalType)varBinaryType);
    }

    public TypeInfo visit(DecimalType decimalType) {
        return TypeInfoFactory.getDecimalTypeInfo((int)decimalType.getPrecision(), (int)decimalType.getScale());
    }

    public TypeInfo visit(TinyIntType tinyIntType) {
        return TypeInfoFactory.intTypeInfo;
    }

    public TypeInfo visit(SmallIntType smallIntType) {
        return TypeInfoFactory.intTypeInfo;
    }

    public TypeInfo visit(IntType intType) {
        return TypeInfoFactory.intTypeInfo;
    }

    public TypeInfo visit(BigIntType bigIntType) {
        return TypeInfoFactory.longTypeInfo;
    }

    public TypeInfo visit(FloatType floatType) {
        return TypeInfoFactory.floatTypeInfo;
    }

    public TypeInfo visit(DoubleType doubleType) {
        return TypeInfoFactory.doubleTypeInfo;
    }

    public TypeInfo visit(DateType dateType) {
        return TypeInfoFactory.dateTypeInfo;
    }

    public TypeInfo visit(TimestampType timestampType) {
        int precision = timestampType.getPrecision();
        if (precision <= 6) {
            return TypeInfoFactory.timestampTypeInfo;
        }
        return TypeInfoFactory.longTypeInfo;
    }

    public TypeInfo visit(ArrayType arrayType) {
        LogicalType elementType = arrayType.getElementType();
        TypeInfo elementTypeInfo = (TypeInfo)elementType.accept((LogicalTypeVisitor)this);
        if (null != elementTypeInfo) {
            return TypeInfoFactory.getListTypeInfo((TypeInfo)elementTypeInfo);
        }
        return this.defaultMethod((LogicalType)arrayType);
    }

    public TypeInfo visit(MapType mapType) {
        LogicalType keyType = mapType.getKeyType();
        LogicalType valueType = mapType.getValueType();
        TypeInfo keyTypeInfo = (TypeInfo)keyType.accept((LogicalTypeVisitor)this);
        TypeInfo valueTypeInfo = (TypeInfo)valueType.accept((LogicalTypeVisitor)this);
        if (null == keyTypeInfo || null == valueTypeInfo) {
            return this.defaultMethod((LogicalType)mapType);
        }
        return TypeInfoFactory.getMapTypeInfo((TypeInfo)keyTypeInfo, (TypeInfo)valueTypeInfo);
    }

    public TypeInfo visit(RowType rowType) {
        List names = rowType.getFieldNames();
        ArrayList<TypeInfo> typeInfos = new ArrayList<TypeInfo>(names.size());
        for (String name2 : names) {
            TypeInfo typeInfo = (TypeInfo)rowType.getTypeAt(rowType.getFieldIndex(name2)).accept((LogicalTypeVisitor)this);
            if (null != typeInfo) {
                typeInfos.add(typeInfo);
                continue;
            }
            return this.defaultMethod((LogicalType)rowType);
        }
        return TypeInfoFactory.getStructTypeInfo((List)names, typeInfos);
    }

    public TypeInfo visit(NullType nullType) {
        return TypeInfoFactory.voidTypeInfo;
    }

    protected TypeInfo defaultMethod(LogicalType logicalType) {
        throw new UnsupportedOperationException(String.format("Flink doesn't support converting type %s to Hive type yet.", this.type.toString()));
    }
}

