/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.format.cow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.io.FilePathFilter;
import org.apache.flink.api.common.io.GlobFilePathFilter;
import org.apache.flink.api.common.io.compression.InflaterInputStreamFactory;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.formats.parquet.utils.SerializableConfiguration;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.source.ExpressionPredicates;
import org.apache.hudi.table.format.FilePathUtils;
import org.apache.hudi.table.format.InternalSchemaManager;
import org.apache.hudi.table.format.RecordIterators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyOnWriteInputFormat
extends FileInputFormat<RowData> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CopyOnWriteInputFormat.class);
    private final String[] fullFieldNames;
    private final DataType[] fullFieldTypes;
    private final int[] selectedFields;
    private final String partDefaultName;
    private final String partPathField;
    private final boolean hiveStylePartitioning;
    private final boolean utcTimestamp;
    private final SerializableConfiguration conf;
    private final List<ExpressionPredicates.Predicate> predicates;
    private final long limit;
    private transient ClosableIterator<RowData> itr;
    private transient long currentReadCount;
    private FilePathFilter localFilesFilter = new GlobFilePathFilter();
    private final InternalSchemaManager internalSchemaManager;

    public CopyOnWriteInputFormat(Path[] paths, String[] fullFieldNames, DataType[] fullFieldTypes, int[] selectedFields, String partDefaultName, String partPathField, boolean hiveStylePartitioning, List<ExpressionPredicates.Predicate> predicates, long limit, Configuration conf, boolean utcTimestamp, InternalSchemaManager internalSchemaManager) {
        super.setFilePaths(paths);
        this.predicates = predicates;
        this.limit = limit;
        this.partDefaultName = partDefaultName;
        this.partPathField = partPathField;
        this.hiveStylePartitioning = hiveStylePartitioning;
        this.fullFieldNames = fullFieldNames;
        this.fullFieldTypes = fullFieldTypes;
        this.selectedFields = selectedFields;
        this.conf = new SerializableConfiguration(conf);
        this.utcTimestamp = utcTimestamp;
        this.internalSchemaManager = internalSchemaManager;
    }

    @Override
    public void open(FileInputSplit fileSplit) throws IOException {
        LinkedHashMap<String, Object> partObjects = FilePathUtils.generatePartitionSpecs(fileSplit.getPath().getPath(), Arrays.asList(this.fullFieldNames), Arrays.asList(this.fullFieldTypes), this.partDefaultName, this.partPathField, this.hiveStylePartitioning);
        this.itr = RecordIterators.getParquetRecordIterator(this.internalSchemaManager, this.utcTimestamp, true, this.conf.conf(), this.fullFieldNames, this.fullFieldTypes, partObjects, this.selectedFields, 2048, fileSplit.getPath(), fileSplit.getStart(), fileSplit.getLength(), this.predicates);
        this.currentReadCount = 0L;
    }

    @Override
    public FileInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        FileSystem fs;
        if (minNumSplits < 1) {
            throw new IllegalArgumentException("Number of input splits has to be at least 1.");
        }
        minNumSplits = Math.max(minNumSplits, this.numSplits);
        ArrayList<FileInputSplit> inputSplits = new ArrayList<FileInputSplit>(minNumSplits);
        ArrayList<FileStatus> files = new ArrayList<FileStatus>();
        long totalLength = 0L;
        for (Path path : this.getFilePaths()) {
            org.apache.hadoop.fs.Path hadoopPath = new org.apache.hadoop.fs.Path(path.toUri());
            fs = HadoopFSUtils.getFs(hadoopPath.toString(), this.conf.conf());
            FileStatus pathFile = fs.getFileStatus(hadoopPath);
            if (pathFile.isDirectory()) {
                totalLength += this.addFilesInDir(hadoopPath, files, true);
                continue;
            }
            this.testForUnsplittable(pathFile);
            files.add(pathFile);
            totalLength += pathFile.getLen();
        }
        if (this.unsplittable) {
            int splitNum = 0;
            for (FileStatus file : files) {
                FileSystem fs2 = HadoopFSUtils.getFs(file.getPath().toString(), this.conf.conf());
                BlockLocation[] blocks = fs2.getFileBlockLocations(file, 0L, file.getLen());
                HashSet<String> hosts = new HashSet<String>();
                for (BlockLocation block : blocks) {
                    hosts.addAll(Arrays.asList(block.getHosts()));
                }
                long len = file.getLen();
                if (this.testForUnsplittable(file)) {
                    len = -1L;
                }
                FileInputSplit fis = new FileInputSplit(splitNum++, new Path(file.getPath().toUri()), 0L, len, hosts.toArray(new String[0]));
                inputSplits.add(fis);
            }
            return inputSplits.toArray(new FileInputSplit[0]);
        }
        long maxSplitSize = totalLength / (long)minNumSplits + (long)(totalLength % (long)minNumSplits == 0L ? 0 : 1);
        int splitNum = 0;
        for (FileStatus file : files) {
            BlockLocation[] blocks;
            long minSplitSize;
            fs = HadoopFSUtils.getFs(file.getPath().toString(), this.conf.conf());
            long len = file.getLen();
            long blockSize = file.getBlockSize();
            if (this.minSplitSize <= blockSize) {
                minSplitSize = this.minSplitSize;
            } else {
                if (LOG.isWarnEnabled()) {
                    LOG.warn("Minimal split size of " + this.minSplitSize + " is larger than the block size of " + blockSize + ". Decreasing minimal split size to block size.");
                }
                minSplitSize = blockSize;
            }
            long splitSize = Math.max(minSplitSize, Math.min(maxSplitSize, blockSize));
            long halfSplit = splitSize >>> 1;
            long maxBytesForLastSplit = (long)((float)splitSize * 1.1f);
            if (len > 0L) {
                FileInputSplit fis;
                long bytesUnassigned;
                blocks = fs.getFileBlockLocations(file, 0L, len);
                Arrays.sort(blocks, Comparator.comparingLong(BlockLocation::getOffset));
                long position = 0L;
                int blockIndex = 0;
                for (bytesUnassigned = len; bytesUnassigned > maxBytesForLastSplit; bytesUnassigned -= splitSize) {
                    blockIndex = this.getBlockIndexForPosition(blocks, position, halfSplit, blockIndex);
                    fis = new FileInputSplit(splitNum++, new Path(file.getPath().toUri()), position, splitSize, blocks[blockIndex].getHosts());
                    inputSplits.add(fis);
                    position += splitSize;
                }
                if (bytesUnassigned <= 0L) continue;
                blockIndex = this.getBlockIndexForPosition(blocks, position, halfSplit, blockIndex);
                fis = new FileInputSplit(splitNum++, new Path(file.getPath().toUri()), position, bytesUnassigned, blocks[blockIndex].getHosts());
                inputSplits.add(fis);
                continue;
            }
            blocks = fs.getFileBlockLocations(file, 0L, 0L);
            String[] hosts = blocks.length > 0 ? blocks[0].getHosts() : new String[]{};
            FileInputSplit fis = new FileInputSplit(splitNum++, new Path(file.getPath().toUri()), 0L, 0L, hosts);
            inputSplits.add(fis);
        }
        return inputSplits.toArray(new FileInputSplit[0]);
    }

    @Override
    public boolean supportsMultiPaths() {
        return true;
    }

    @Override
    public boolean reachedEnd() {
        if (this.currentReadCount >= this.limit) {
            return true;
        }
        return !this.itr.hasNext();
    }

    @Override
    public RowData nextRecord(RowData reuse) {
        ++this.currentReadCount;
        return (RowData)this.itr.next();
    }

    @Override
    public void close() throws IOException {
        if (this.itr != null) {
            this.itr.close();
        }
        this.itr = null;
    }

    private long addFilesInDir(org.apache.hadoop.fs.Path path, List<FileStatus> files, boolean logExcludedFiles) throws IOException {
        org.apache.hadoop.fs.Path hadoopPath = new org.apache.hadoop.fs.Path(path.toUri());
        FileSystem fs = HadoopFSUtils.getFs(hadoopPath.toString(), this.conf.conf());
        long length = 0L;
        for (FileStatus dir : fs.listStatus(hadoopPath)) {
            if (dir.isDirectory()) {
                if (this.acceptFile(dir) && this.enumerateNestedFiles) {
                    length += this.addFilesInDir(dir.getPath(), files, logExcludedFiles);
                    continue;
                }
                if (!logExcludedFiles || !LOG.isDebugEnabled()) continue;
                LOG.debug("Directory " + dir.getPath().toString() + " did not pass the file-filter and is excluded.");
                continue;
            }
            if (this.acceptFile(dir)) {
                files.add(dir);
                length += dir.getLen();
                this.testForUnsplittable(dir);
                continue;
            }
            if (!logExcludedFiles || !LOG.isDebugEnabled()) continue;
            LOG.debug("Directory " + dir.getPath().toString() + " did not pass the file-filter and is excluded.");
        }
        return length;
    }

    @Override
    public void setFilesFilter(FilePathFilter filesFilter) {
        this.localFilesFilter = filesFilter;
        super.setFilesFilter(filesFilter);
    }

    public boolean acceptFile(FileStatus fileStatus) {
        String name2 = fileStatus.getPath().getName();
        return !name2.startsWith("_") && !name2.startsWith(".") && !this.localFilesFilter.filterPath(new Path(fileStatus.getPath().toUri()));
    }

    private int getBlockIndexForPosition(BlockLocation[] blocks, long offset, long halfSplitSize, int startIndex) {
        for (int i = startIndex; i < blocks.length; ++i) {
            long blockStart = blocks[i].getOffset();
            long blockEnd = blockStart + blocks[i].getLength();
            if (offset < blockStart || offset >= blockEnd) continue;
            if (i < blocks.length - 1 && blockEnd - offset < halfSplitSize) {
                return i + 1;
            }
            return i;
        }
        throw new IllegalArgumentException("The given offset is not contained in the any block.");
    }

    private boolean testForUnsplittable(FileStatus pathFile) {
        if (this.getInflaterInputStreamFactory(pathFile.getPath()) != null) {
            this.unsplittable = true;
            return true;
        }
        return false;
    }

    private InflaterInputStreamFactory<?> getInflaterInputStreamFactory(org.apache.hadoop.fs.Path path) {
        String fileExtension2 = CopyOnWriteInputFormat.extractFileExtension(path.getName());
        if (fileExtension2 != null) {
            return CopyOnWriteInputFormat.getInflaterInputStreamFactory(fileExtension2);
        }
        return null;
    }
}

