/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.lookup;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.table.data.RowData;
import org.apache.hudi.common.function.SerializableSupplier;
import org.jetbrains.annotations.Nullable;

public class HoodieLookupTableReader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final SerializableSupplier<InputFormat<RowData, ?>> inputFormatSupplier;
    private final Configuration conf;
    private InputFormat inputFormat;
    private List<InputSplit> inputSplits;

    public HoodieLookupTableReader(SerializableSupplier<InputFormat<RowData, ?>> inputFormatSupplier, Configuration conf) {
        this.inputFormatSupplier = inputFormatSupplier;
        this.conf = conf;
    }

    public void open() throws IOException {
        this.inputFormat = this.inputFormatSupplier.get();
        this.inputFormat.configure(this.conf);
        this.inputSplits = Arrays.stream(this.inputFormat.createInputSplits(1)).collect(Collectors.toList());
        ((RichInputFormat)this.inputFormat).openInputFormat();
        this.inputFormat.open(this.inputSplits.remove(0));
    }

    @Nullable
    public RowData read(RowData reuse) throws IOException {
        if (!this.inputFormat.reachedEnd()) {
            return this.inputFormat.nextRecord(reuse);
        }
        while (!this.inputSplits.isEmpty()) {
            this.inputFormat.close();
            this.inputFormat.open(this.inputSplits.remove(0));
            if (this.inputFormat.reachedEnd()) continue;
            return this.inputFormat.nextRecord(reuse);
        }
        return null;
    }

    public void close() throws IOException {
        if (this.inputFormat != null) {
            this.inputFormat.close();
        }
        if (this.inputFormat instanceof RichInputFormat) {
            ((RichInputFormat)this.inputFormat).closeInputFormat();
        }
    }
}

