/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline;

import io.hops.hudi.com.fasterxml.jackson.core.JsonProcessingException;
import io.hops.hudi.com.fasterxml.jackson.core.type.TypeReference;
import io.hops.hudi.com.fasterxml.jackson.databind.ObjectMapper;
import io.hops.hudi.com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.RetryHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TimelineServiceClientBase
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineServiceClientBase.class);
    private RetryHelper<Response, IOException> retryHelper;

    protected TimelineServiceClientBase(FileSystemViewStorageConfig config) {
        if (config.getBooleanOrDefault(FileSystemViewStorageConfig.REMOTE_RETRY_ENABLE)) {
            this.retryHelper = new RetryHelper((long)config.getRemoteTimelineClientMaxRetryIntervalMs(), (int)config.getRemoteTimelineClientMaxRetryNumbers(), (long)config.getRemoteTimelineInitialRetryIntervalMs(), config.getRemoteTimelineClientRetryExceptions(), "Sending request to timeline server");
        }
    }

    protected abstract Response executeRequest(Request var1) throws IOException;

    public Response makeRequest(Request request) throws IOException {
        return this.retryHelper != null ? this.retryHelper.start(() -> this.executeRequest(request)) : this.executeRequest(request);
    }

    public static enum RequestMethod {
        GET,
        POST;

    }

    public static class Response {
        private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule(new AfterburnerModule());
        private final String content;

        public Response(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }

        public <T> T getDecodedContent(TypeReference reference) throws JsonProcessingException {
            return OBJECT_MAPPER.readValue(this.content, reference);
        }
    }

    public static class Request {
        private final RequestMethod method;
        private final String path;
        private final Option<Map<String, String>> queryParameters;

        private Request(RequestMethod method, String path, Option<Map<String, String>> queryParameters) {
            this.method = method;
            this.path = path;
            this.queryParameters = queryParameters;
        }

        public RequestMethod getMethod() {
            return this.method;
        }

        public String getPath() {
            return this.path;
        }

        public Option<Map<String, String>> getQueryParameters() {
            return this.queryParameters;
        }

        public static Builder newBuilder(RequestMethod method, String path) {
            return new Builder(method, path);
        }

        public static class Builder {
            private final RequestMethod method;
            private final String path;
            private Option<Map<String, String>> queryParameters;

            public Builder(RequestMethod method, String path) {
                this.method = method;
                this.path = path;
                this.queryParameters = Option.empty();
            }

            public Builder addQueryParam(String key, String value) {
                this.queryParameters = this.queryParameters.isPresent() ? this.queryParameters : Option.of(new HashMap());
                this.queryParameters.get().put(key, value);
                return this;
            }

            public Builder addQueryParams(Map<String, String> parameters2) {
                this.queryParameters = this.queryParameters.isPresent() ? this.queryParameters : Option.of(new HashMap());
                this.queryParameters.get().putAll(parameters2);
                return this;
            }

            public Request build() {
                return new Request(this.method, this.path, this.queryParameters);
            }
        }
    }
}

