/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers.marker;

import io.hops.hudi.com.fasterxml.jackson.core.JsonProcessingException;
import io.hops.hudi.com.fasterxml.jackson.databind.ObjectMapper;
import io.hops.hudi.com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.common.conflict.detection.TimelineServerBasedDetectionStrategy;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieEarlyConflictDetectionException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.timeline.service.RequestHandler;
import org.apache.hudi.timeline.service.handlers.marker.MarkerCreationFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerDirState
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(MarkerDirState.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule(new AfterburnerModule());
    private final String markerDirPath;
    private final HoodieStorage storage;
    private final Registry metricsRegistry;
    private final Set<String> allMarkers = new HashSet<String>();
    private final Map<Integer, StringBuilder> fileMarkersMap = new HashMap<Integer, StringBuilder>();
    private final List<Boolean> threadUseStatus;
    private final List<MarkerCreationFuture> markerCreationFutures = new ArrayList<MarkerCreationFuture>();
    private final int parallelism;
    private final Object markerCreationProcessingLock = new Object();
    private final Option<TimelineServerBasedDetectionStrategy> conflictDetectionStrategy;
    private transient HoodieEngineContext hoodieEngineContext;
    private int lastFileIndexUsed = -1;
    private boolean isMarkerTypeWritten = false;

    public MarkerDirState(String markerDirPath, int markerBatchNumThreads, Option<TimelineServerBasedDetectionStrategy> conflictDetectionStrategy, HoodieStorage storage2, Registry metricsRegistry, HoodieEngineContext hoodieEngineContext, int parallelism) {
        this.markerDirPath = markerDirPath;
        this.storage = storage2;
        this.metricsRegistry = metricsRegistry;
        this.hoodieEngineContext = hoodieEngineContext;
        this.parallelism = parallelism;
        this.threadUseStatus = Stream.generate(() -> false).limit(markerBatchNumThreads).collect(Collectors.toList());
        this.conflictDetectionStrategy = conflictDetectionStrategy;
        this.syncMarkersFromFileSystem();
    }

    public boolean exists() {
        try {
            return this.storage.exists(new StoragePath(this.markerDirPath));
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    public Set<String> getAllMarkers() {
        return this.allMarkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMarkerCreationFuture(MarkerCreationFuture future) {
        List<MarkerCreationFuture> list = this.markerCreationFutures;
        synchronized (list) {
            this.markerCreationFutures.add(future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Option<Integer> getNextFileIndexToUse() {
        int fileIndex = -1;
        Object object = this.markerCreationProcessingLock;
        synchronized (object) {
            for (int i = 0; i < this.threadUseStatus.size(); ++i) {
                int index = (this.lastFileIndexUsed + 1 + i) % this.threadUseStatus.size();
                if (this.threadUseStatus.get(index).booleanValue()) continue;
                fileIndex = index;
                this.threadUseStatus.set(index, true);
                break;
            }
            if (fileIndex >= 0) {
                this.lastFileIndexUsed = fileIndex;
                return Option.of(fileIndex);
            }
        }
        return Option.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileAsAvailable(int fileIndex) {
        Object object = this.markerCreationProcessingLock;
        synchronized (object) {
            this.threadUseStatus.set(fileIndex, false);
        }
    }

    public List<MarkerCreationFuture> fetchPendingMarkerCreationRequests() {
        return this.getPendingMarkerCreationRequests(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MarkerCreationFuture> getPendingMarkerCreationRequests(boolean shouldClear) {
        ArrayList<MarkerCreationFuture> pendingFutures;
        List<MarkerCreationFuture> list = this.markerCreationFutures;
        synchronized (list) {
            if (this.markerCreationFutures.isEmpty()) {
                return new ArrayList<MarkerCreationFuture>();
            }
            pendingFutures = new ArrayList<MarkerCreationFuture>(this.markerCreationFutures);
            if (shouldClear) {
                this.markerCreationFutures.clear();
            }
        }
        return pendingFutures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMarkerCreationRequests(List<MarkerCreationFuture> pendingMarkerCreationFutures, int fileIndex) {
        if (pendingMarkerCreationFutures.isEmpty()) {
            this.markFileAsAvailable(fileIndex);
            return;
        }
        LOG.debug("timeMs=" + System.currentTimeMillis() + " markerDirPath=" + this.markerDirPath + " numRequests=" + pendingMarkerCreationFutures.size() + " fileIndex=" + fileIndex);
        boolean shouldFlushMarkers = false;
        Iterator<MarkerCreationFuture> iterator2 = this.markerCreationProcessingLock;
        synchronized (iterator2) {
            for (MarkerCreationFuture future : pendingMarkerCreationFutures) {
                String markerName = future.getMarkerName();
                boolean exists = this.allMarkers.contains(markerName);
                if (!exists) {
                    if (this.conflictDetectionStrategy.isPresent()) {
                        try {
                            this.conflictDetectionStrategy.get().detectAndResolveConflictIfNecessary();
                        }
                        catch (HoodieEarlyConflictDetectionException he) {
                            LOG.warn("Detected the write conflict due to a concurrent writer, failing the marker creation as the early conflict detection is enabled", (Throwable)he);
                            future.setResult(false);
                            continue;
                        }
                        catch (Exception e) {
                            LOG.warn("Failed to execute early conflict detection." + e.getMessage());
                            this.addMarkerToMap(fileIndex, markerName);
                            future.setResult(true);
                            shouldFlushMarkers = true;
                            continue;
                        }
                    }
                    this.addMarkerToMap(fileIndex, markerName);
                    shouldFlushMarkers = true;
                }
                future.setResult(!exists);
            }
            if (!this.isMarkerTypeWritten) {
                this.writeMarkerTypeToFile();
                this.isMarkerTypeWritten = true;
            }
        }
        if (shouldFlushMarkers) {
            this.flushMarkersToFile(fileIndex);
        }
        this.markFileAsAvailable(fileIndex);
        for (MarkerCreationFuture future : pendingMarkerCreationFutures) {
            try {
                future.complete(RequestHandler.jsonifyResult(future.getContext(), future.isSuccessful(), this.metricsRegistry, OBJECT_MAPPER, LOG));
            }
            catch (JsonProcessingException e) {
                throw new HoodieException("Failed to JSON encode the value", e);
            }
        }
    }

    public boolean deleteAllMarkers() {
        boolean result2 = FSUtils.deleteDir(this.hoodieEngineContext, this.storage, new StoragePath(this.markerDirPath), this.parallelism);
        this.allMarkers.clear();
        this.fileMarkersMap.clear();
        return result2;
    }

    private void syncMarkersFromFileSystem() {
        Map<String, Set<String>> fileMarkersSetMap = MarkerUtils.readTimelineServerBasedMarkersFromFileSystem(this.markerDirPath, this.storage, this.hoodieEngineContext, this.parallelism);
        for (String markersFilePathStr : fileMarkersSetMap.keySet()) {
            int index;
            Set<String> fileMarkers = fileMarkersSetMap.get(markersFilePathStr);
            if (fileMarkers.isEmpty() || (index = this.parseMarkerFileIndex(markersFilePathStr)) < 0) continue;
            this.fileMarkersMap.put(index, new StringBuilder(StringUtils.join((CharSequence)",", fileMarkers)));
            this.allMarkers.addAll(fileMarkers);
        }
        try {
            if (MarkerUtils.doesMarkerTypeFileExist(this.storage, this.markerDirPath)) {
                this.isMarkerTypeWritten = true;
            }
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    private void addMarkerToMap(int fileIndex, String markerName) {
        this.allMarkers.add(markerName);
        StringBuilder stringBuilder = this.fileMarkersMap.computeIfAbsent(fileIndex, k -> new StringBuilder(16384));
        stringBuilder.append(markerName);
        stringBuilder.append('\n');
    }

    private void writeMarkerTypeToFile() {
        StoragePath dirPath = new StoragePath(this.markerDirPath);
        try {
            if (!this.storage.exists(dirPath) || !MarkerUtils.doesMarkerTypeFileExist(this.storage, this.markerDirPath)) {
                this.storage.createDirectory(dirPath);
                MarkerUtils.writeMarkerTypeToFile(MarkerType.TIMELINE_SERVER_BASED, this.storage, this.markerDirPath);
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to write marker type file in " + this.markerDirPath + ": " + e.getMessage(), e);
        }
    }

    private int parseMarkerFileIndex(String markerFilePathStr) {
        String markerFileName = new StoragePath(markerFilePathStr).getName();
        int prefixIndex = markerFileName.indexOf("MARKERS");
        if (prefixIndex < 0) {
            return -1;
        }
        try {
            return Integer.parseInt(markerFileName.substring(prefixIndex + "MARKERS".length()));
        }
        catch (NumberFormatException nfe) {
            LOG.error("Failed to parse marker file index from " + markerFilePathStr);
            throw new HoodieException(nfe.getMessage(), nfe);
        }
    }

    private void flushMarkersToFile(int markerFileIndex) {
        LOG.debug("Write to " + this.markerDirPath + "/" + "MARKERS" + markerFileIndex);
        HoodieTimer timer = HoodieTimer.start();
        StoragePath markersFilePath = new StoragePath(this.markerDirPath, "MARKERS" + markerFileIndex);
        OutputStream outputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            outputStream = this.storage.create(markersFilePath);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
            bufferedWriter.write(this.fileMarkersMap.get(markerFileIndex).toString());
        }
        catch (IOException e) {
            try {
                throw new HoodieIOException("Failed to overwrite marker file " + markersFilePath, e);
            }
            catch (Throwable throwable) {
                FileIOUtils.closeQuietly(bufferedWriter);
                FileIOUtils.closeQuietly(outputStream);
                throw throwable;
            }
        }
        FileIOUtils.closeQuietly(bufferedWriter);
        FileIOUtils.closeQuietly(outputStream);
        LOG.debug(markersFilePath + " written in " + timer.endTimer() + " ms");
    }
}

