/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.hudi.util.AvroSchemaConverter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.LocalTime;

@Internal
public class AvroToRowDataConverters {
    public static AvroToRowDataConverter createRowConverter(RowType rowType) {
        return AvroToRowDataConverters.createRowConverter(rowType, true);
    }

    public static AvroToRowDataConverter createRowConverter(RowType rowType, boolean utcTimezone) {
        AvroToRowDataConverter[] fieldConverters = (AvroToRowDataConverter[])rowType.getFields().stream().map(RowType.RowField::getType).map(type2 -> AvroToRowDataConverters.createNullableConverter(type2, utcTimezone)).toArray(AvroToRowDataConverter[]::new);
        int arity = rowType.getFieldCount();
        return avroObject -> {
            IndexedRecord record = (IndexedRecord)avroObject;
            GenericRowData row = new GenericRowData(arity);
            for (int i = 0; i < arity; ++i) {
                row.setField(i, fieldConverters[i].convert(record.get(i)));
            }
            return row;
        };
    }

    private static AvroToRowDataConverter createNullableConverter(LogicalType type2, boolean utcTimezone) {
        AvroToRowDataConverter converter = AvroToRowDataConverters.createConverter(type2, utcTimezone);
        return avroObject -> {
            if (avroObject == null) {
                return null;
            }
            return converter.convert(avroObject);
        };
    }

    public static AvroToRowDataConverter createConverter(LogicalType type2, boolean utcTimezone) {
        switch (type2.getTypeRoot()) {
            case NULL: {
                return avroObject -> null;
            }
            case TINYINT: {
                return avroObject -> ((Integer)avroObject).byteValue();
            }
            case SMALLINT: {
                return avroObject -> ((Integer)avroObject).shortValue();
            }
            case BOOLEAN: 
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: 
            case BIGINT: 
            case INTERVAL_DAY_TIME: 
            case FLOAT: 
            case DOUBLE: 
            case RAW: {
                return avroObject -> avroObject;
            }
            case DATE: {
                return AvroToRowDataConverters::convertToDate;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return AvroToRowDataConverters::convertToTime;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return AvroToRowDataConverters.createTimestampConverter(((LocalZonedTimestampType)type2).getPrecision(), true);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return AvroToRowDataConverters.createTimestampConverter(((TimestampType)type2).getPrecision(), utcTimezone);
            }
            case CHAR: 
            case VARCHAR: {
                return avroObject -> StringData.fromString((String)avroObject.toString());
            }
            case BINARY: 
            case VARBINARY: {
                return AvroToRowDataConverters::convertToBytes;
            }
            case DECIMAL: {
                return AvroToRowDataConverters.createDecimalConverter((DecimalType)type2);
            }
            case ARRAY: {
                return AvroToRowDataConverters.createArrayConverter((ArrayType)type2, utcTimezone);
            }
            case ROW: {
                return AvroToRowDataConverters.createRowConverter((RowType)type2, utcTimezone);
            }
            case MAP: 
            case MULTISET: {
                return AvroToRowDataConverters.createMapConverter(type2, utcTimezone);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type2);
    }

    private static AvroToRowDataConverter createDecimalConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return avroObject -> {
            byte[] bytes;
            if (avroObject instanceof GenericFixed) {
                bytes = ((GenericFixed)avroObject).bytes();
            } else if (avroObject instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)avroObject;
                bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
            } else {
                bytes = (byte[])avroObject;
            }
            return DecimalData.fromUnscaledBytes((byte[])bytes, (int)precision, (int)scale);
        };
    }

    private static AvroToRowDataConverter createArrayConverter(ArrayType arrayType, boolean utcTimezone) {
        AvroToRowDataConverter elementConverter = AvroToRowDataConverters.createNullableConverter(arrayType.getElementType(), utcTimezone);
        Class elementClass = LogicalTypeUtils.toInternalConversionClass((LogicalType)arrayType.getElementType());
        return avroObject -> {
            List list = (List)avroObject;
            int length = list.size();
            Object[] array = (Object[])Array.newInstance(elementClass, length);
            for (int i = 0; i < length; ++i) {
                array[i] = elementConverter.convert(list.get(i));
            }
            return new GenericArrayData(array);
        };
    }

    private static AvroToRowDataConverter createMapConverter(LogicalType type2, boolean utcTimezone) {
        AvroToRowDataConverter keyConverter = AvroToRowDataConverters.createConverter(DataTypes.STRING().getLogicalType(), utcTimezone);
        AvroToRowDataConverter valueConverter = AvroToRowDataConverters.createNullableConverter(AvroSchemaConverter.extractValueTypeToAvroMap(type2), utcTimezone);
        return avroObject -> {
            Map map2 = (Map)avroObject;
            HashMap<Object, Object> result2 = new HashMap<Object, Object>();
            for (Map.Entry entry : map2.entrySet()) {
                Object key = keyConverter.convert(entry.getKey());
                Object value = valueConverter.convert(entry.getValue());
                result2.put(key, value);
            }
            return new GenericMapData(result2);
        };
    }

    private static AvroToRowDataConverter createTimestampConverter(int precision, boolean utcTimezone) {
        ChronoUnit chronoUnit;
        if (precision <= 3) {
            chronoUnit = ChronoUnit.MILLIS;
        } else if (precision <= 6) {
            chronoUnit = ChronoUnit.MICROS;
        } else {
            throw new IllegalArgumentException("Avro does not support TIMESTAMP type with precision: " + precision + ", it only support precisions <= 6.");
        }
        return avroObject -> {
            Instant instant;
            if (avroObject instanceof Long) {
                instant = Instant.EPOCH.plus((long)((Long)avroObject), chronoUnit);
            } else if (avroObject instanceof Instant) {
                instant = (Instant)avroObject;
            } else {
                JodaConverter jodaConverter = JodaConverter.getConverter();
                if (jodaConverter != null) {
                    instant = Instant.ofEpochMilli(jodaConverter.convertTimestamp(avroObject));
                } else {
                    throw new IllegalArgumentException("Unexpected object type for TIMESTAMP logical type. Received: " + avroObject);
                }
            }
            if (utcTimezone) {
                return TimestampData.fromInstant((Instant)instant);
            }
            return TimestampData.fromTimestamp((Timestamp)Timestamp.from(instant));
        };
    }

    private static int convertToDate(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof LocalDate) {
            return (int)((LocalDate)object).toEpochDay();
        }
        JodaConverter jodaConverter = JodaConverter.getConverter();
        if (jodaConverter != null) {
            return (int)jodaConverter.convertDate(object);
        }
        throw new IllegalArgumentException("Unexpected object type for DATE logical type. Received: " + object);
    }

    private static int convertToTime(Object object) {
        int millis;
        if (object instanceof Integer) {
            millis = (Integer)object;
        } else if (object instanceof java.time.LocalTime) {
            millis = ((java.time.LocalTime)object).get(ChronoField.MILLI_OF_DAY);
        } else {
            JodaConverter jodaConverter = JodaConverter.getConverter();
            if (jodaConverter != null) {
                millis = jodaConverter.convertTime(object);
            } else {
                throw new IllegalArgumentException("Unexpected object type for TIME logical type. Received: " + object);
            }
        }
        return millis;
    }

    private static byte[] convertToBytes(Object object) {
        if (object instanceof GenericFixed) {
            return ((GenericFixed)object).bytes();
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return bytes;
        }
        return (byte[])object;
    }

    static class JodaConverter {
        private static JodaConverter instance;

        public static JodaConverter getConverter() {
            if (instance != null) {
                return instance;
            }
            try {
                Class.forName("org.joda.time.DateTime", false, Thread.currentThread().getContextClassLoader());
                instance = new JodaConverter();
            }
            catch (ClassNotFoundException e) {
                instance = null;
            }
            return instance;
        }

        public long convertDate(Object object) {
            org.joda.time.LocalDate value = (org.joda.time.LocalDate)object;
            return value.toDate().getTime();
        }

        public int convertTime(Object object) {
            LocalTime value = (LocalTime)object;
            return value.get(DateTimeFieldType.millisOfDay());
        }

        public long convertTimestamp(Object object) {
            DateTime value = (DateTime)object;
            return value.toDate().getTime();
        }

        private JodaConverter() {
        }
    }

    @FunctionalInterface
    public static interface AvroToRowDataConverter
    extends Serializable {
        public Object convert(Object var1);
    }
}

