/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;

public class DataTypeUtils {
    public static boolean isTimestampType(DataType type2) {
        return type2.getLogicalType().getTypeRoot() == LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE;
    }

    public static int precision(LogicalType logicalType) {
        if (logicalType instanceof TimestampType) {
            return ((TimestampType)logicalType).getPrecision();
        }
        if (logicalType instanceof LocalZonedTimestampType) {
            return ((LocalZonedTimestampType)logicalType).getPrecision();
        }
        throw new AssertionError((Object)("Unexpected type: " + logicalType));
    }

    public static boolean isDateType(DataType type2) {
        return type2.getLogicalType().getTypeRoot() == LogicalTypeRoot.DATE;
    }

    public static boolean isDatetimeType(DataType type2) {
        return DataTypeUtils.isTimestampType(type2) || DataTypeUtils.isDateType(type2);
    }

    public static RowType.RowField[] projectRowFields(RowType rowType, String[] names) {
        int[] fieldIndices = Arrays.stream(names).mapToInt(arg_0 -> ((RowType)rowType).getFieldIndex(arg_0)).toArray();
        return (RowType.RowField[])Arrays.stream(fieldIndices).mapToObj(i -> (RowType.RowField)rowType.getFields().get(i)).toArray(RowType.RowField[]::new);
    }

    public static boolean isFamily(LogicalType logicalType, LogicalTypeFamily family) {
        return logicalType.getTypeRoot().getFamilies().contains(family);
    }

    public static Object resolvePartition(String partition, DataType type2) {
        if (partition == null) {
            return null;
        }
        LogicalTypeRoot typeRoot = type2.getLogicalType().getTypeRoot();
        switch (typeRoot) {
            case CHAR: 
            case VARCHAR: {
                return partition;
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(partition);
            }
            case TINYINT: {
                return Integer.valueOf(partition).byteValue();
            }
            case SMALLINT: {
                return Short.valueOf(partition);
            }
            case INTEGER: {
                return Integer.valueOf(partition);
            }
            case BIGINT: {
                return Long.valueOf(partition);
            }
            case FLOAT: {
                return Float.valueOf(partition);
            }
            case DOUBLE: {
                return Double.valueOf(partition);
            }
            case DATE: {
                return LocalDate.parse(partition);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return LocalDateTime.parse(partition);
            }
            case DECIMAL: {
                return new BigDecimal(partition);
            }
        }
        throw new RuntimeException(String.format("Can not convert %s to type %s for partition value", partition, type2));
    }

    public static DataType ensureColumnsAsNonNullable(DataType dataType, @Nullable List<String> pkColumns) {
        if (pkColumns == null || pkColumns.isEmpty()) {
            return dataType;
        }
        LogicalType dataTypeLogicalType = dataType.getLogicalType();
        if (!(dataTypeLogicalType instanceof RowType)) {
            throw new RuntimeException("The datatype to be converted must be row type, but this type is :" + dataTypeLogicalType.getClass());
        }
        RowType rowType = (RowType)dataTypeLogicalType;
        List originalFieldTypes = dataType.getChildren();
        List fieldNames = rowType.getFieldNames();
        ArrayList<Object> fieldTypes = new ArrayList<Object>();
        boolean tweaked = false;
        for (int i = 0; i < fieldNames.size(); ++i) {
            if (pkColumns.contains(fieldNames.get(i)) && rowType.getTypeAt(i).isNullable()) {
                fieldTypes.add(((DataType)originalFieldTypes.get(i)).notNull());
                tweaked = true;
                continue;
            }
            fieldTypes.add(originalFieldTypes.get(i));
        }
        if (!tweaked) {
            return dataType;
        }
        ArrayList<DataTypes.Field> fields2 = new ArrayList<DataTypes.Field>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            fields2.add(DataTypes.FIELD((String)((String)fieldNames.get(i)), (DataType)((DataType)fieldTypes.get(i))));
        }
        return (DataType)DataTypes.ROW((DataTypes.Field[])((DataTypes.Field[])fields2.stream().toArray(DataTypes.Field[]::new))).notNull();
    }
}

