/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.util;

import java.io.File;
import org.apache.flink.api.java.hadoop.mapred.utils.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;

public class FlinkClientUtil {
    public static HoodieTableMetaClient createMetaClient(String basePath) {
        return HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HadoopFSUtils.getStorageConfWithCopy(FlinkClientUtil.getHadoopConf())).build();
    }

    public static Configuration getHadoopConf() {
        String possibleHadoopConfPath;
        Configuration hadoopConf = null;
        String[] stringArray = HadoopUtils.possibleHadoopConfPaths((org.apache.flink.configuration.Configuration)new org.apache.flink.configuration.Configuration());
        int n = stringArray.length;
        for (int i = 0; i < n && (hadoopConf = FlinkClientUtil.getHadoopConfiguration(possibleHadoopConfPath = stringArray[i])) == null; ++i) {
        }
        if (hadoopConf == null) {
            hadoopConf = new Configuration();
        }
        return hadoopConf;
    }

    private static Configuration getHadoopConfiguration(String hadoopConfDir) {
        if (new File(hadoopConfDir).exists()) {
            File mapredSite;
            File yarnSite;
            File hdfsSite;
            Configuration hadoopConfiguration = new Configuration();
            File coreSite = new File(hadoopConfDir, "core-site.xml");
            if (coreSite.exists()) {
                hadoopConfiguration.addResource(new Path(coreSite.getAbsolutePath()));
            }
            if ((hdfsSite = new File(hadoopConfDir, "hdfs-site.xml")).exists()) {
                hadoopConfiguration.addResource(new Path(hdfsSite.getAbsolutePath()));
            }
            if ((yarnSite = new File(hadoopConfDir, "yarn-site.xml")).exists()) {
                hadoopConfiguration.addResource(new Path(yarnSite.getAbsolutePath()));
            }
            if ((mapredSite = new File(hadoopConfDir, "mapred-site.xml")).exists()) {
                hadoopConfiguration.addResource(new Path(mapredSite.getAbsolutePath()));
            }
            return hadoopConfiguration;
        }
        return null;
    }
}

