/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import io.hops.hudi.com.beust.jcommander.JCommander;
import io.hops.hudi.com.beust.jcommander.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.SparkAdapterSupport$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.IdentitySplitter;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.spark.api.java.JavaSparkContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieCleaner {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCleaner.class);
    private final Config cfg;
    private transient JavaSparkContext jssc;
    private final TypedProperties props;

    public HoodieCleaner(Config cfg, JavaSparkContext jssc) {
        this(cfg, jssc, UtilHelpers.buildProperties(jssc.hadoopConfiguration(), cfg.propsFilePath, cfg.configs));
    }

    public HoodieCleaner(Config cfg, JavaSparkContext jssc, TypedProperties props) {
        this.cfg = cfg;
        this.jssc = jssc;
        this.props = props;
        LOG.info("Creating Cleaner with configs : " + props.toString());
    }

    public void run() {
        HoodieWriteConfig hoodieCfg = this.getHoodieClientConfig();
        try (SparkRDDWriteClient client = new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(this.jssc), hoodieCfg);){
            client.clean();
        }
    }

    private HoodieWriteConfig getHoodieClientConfig() {
        return HoodieWriteConfig.newBuilder().combineInput(true, true).withPath(this.cfg.basePath).withAutoCommit(false).withProps(this.props).build();
    }

    public static void main(String[] args2) {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, null, args2);
        if (cfg.help.booleanValue() || args2.length == 0) {
            cmd.usage();
            throw new HoodieException("Failed to run cleaning for " + cfg.basePath);
        }
        String dirName = new Path(cfg.basePath).getName();
        JavaSparkContext jssc = UtilHelpers.buildSparkContext("hoodie-cleaner-" + dirName, cfg.sparkMaster);
        int exitCode = 0;
        try {
            new HoodieCleaner(cfg, jssc).run();
        }
        catch (Throwable throwable) {
            exitCode = 1;
            throw new HoodieException("Failed to run cleaning for " + cfg.basePath, throwable);
        }
        finally {
            SparkAdapterSupport$.MODULE$.sparkAdapter().stopSparkContext(jssc, exitCode);
        }
        LOG.info("Cleaner ran successfully");
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--target-base-path"}, description="base path for the hoodie table to be cleaner.", required=true)
        public String basePath;
        @Parameter(names={"--props"}, description="path to properties file on localfs or dfs, with configurations for hoodie client for cleaning")
        public String propsFilePath = null;
        @Parameter(names={"--hoodie-conf"}, description="Any configuration that can be set in the properties file (using the CLI parameter \"--props\") can also be passed command line using this parameter. This can be repeated", splitter=IdentitySplitter.class)
        public List<String> configs = new ArrayList<String>();
        @Parameter(names={"--spark-master"}, description="spark master to use.")
        public String sparkMaster = "k8s";
        @Parameter(names={"--help", "-h"}, help=true)
        public Boolean help = false;
    }
}

