/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.multitable;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.HoodieCleaner;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.hudi.utilities.multitable.TableServiceTask;
import org.apache.spark.api.java.JavaSparkContext;

class CleanTask
extends TableServiceTask {
    CleanTask() {
    }

    @Override
    void run() {
        HoodieCleaner.Config cleanConfig = new HoodieCleaner.Config();
        cleanConfig.basePath = this.basePath;
        UtilHelpers.retry(this.retry, () -> {
            new HoodieCleaner(cleanConfig, this.jsc, this.props).run();
            return 0;
        }, "Clean Failed");
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TypedProperties props;
        private String basePath;
        private int retry;
        private JavaSparkContext jsc;

        public Builder withProps(TypedProperties props) {
            this.props = props;
            return this;
        }

        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder withJsc(JavaSparkContext jsc) {
            this.jsc = jsc;
            return this;
        }

        public Builder withRetry(int retry) {
            this.retry = retry;
            return this;
        }

        public CleanTask build() {
            CleanTask cleanTask = new CleanTask();
            cleanTask.jsc = this.jsc;
            cleanTask.retry = this.retry;
            cleanTask.basePath = this.basePath;
            cleanTask.props = this.props;
            return cleanTask;
        }
    }
}

