/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.multitable;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.utilities.HoodieClusteringJob;
import org.apache.hudi.utilities.multitable.TableServiceTask;
import org.apache.spark.api.java.JavaSparkContext;

class ClusteringTask
extends TableServiceTask {
    private int parallelism;
    private String clusteringMode;
    private HoodieTableMetaClient metaClient;

    ClusteringTask() {
    }

    @Override
    void run() {
        HoodieClusteringJob.Config clusteringConfig = new HoodieClusteringJob.Config();
        clusteringConfig.basePath = this.basePath;
        clusteringConfig.parallelism = this.parallelism;
        clusteringConfig.runningMode = this.clusteringMode;
        new HoodieClusteringJob(this.jsc, clusteringConfig, this.props, this.metaClient).cluster(this.retry);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TypedProperties props;
        private int parallelism;
        private String clusteringMode;
        private String basePath;
        private JavaSparkContext jsc;
        private int retry;
        private HoodieTableMetaClient metaClient;

        private Builder() {
        }

        public Builder withProps(TypedProperties props) {
            this.props = props;
            return this;
        }

        public Builder withParallelism(int parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public Builder withClusteringRunningMode(String clusteringRunningMode) {
            this.clusteringMode = clusteringRunningMode;
            return this;
        }

        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder withJsc(JavaSparkContext jsc) {
            this.jsc = jsc;
            return this;
        }

        public Builder withRetry(int retry) {
            this.retry = retry;
            return this;
        }

        public Builder withMetaclient(HoodieTableMetaClient metaClient) {
            this.metaClient = metaClient;
            return this;
        }

        public ClusteringTask build() {
            ClusteringTask clusteringTask = new ClusteringTask();
            clusteringTask.jsc = this.jsc;
            clusteringTask.parallelism = this.parallelism;
            clusteringTask.clusteringMode = this.clusteringMode;
            clusteringTask.retry = this.retry;
            clusteringTask.basePath = this.basePath;
            clusteringTask.props = this.props;
            clusteringTask.metaClient = this.metaClient;
            return clusteringTask;
        }
    }
}

