/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.json.JsonSchema;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.utilities.config.FilebasedSchemaProviderConfig;
import org.apache.hudi.utilities.config.HoodieSchemaProviderConfig;
import org.apache.hudi.utilities.exception.HoodieSchemaProviderException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.schema.SchemaRegistryProvider;
import org.apache.hudi.utilities.sources.helpers.SanitizationUtils;
import org.apache.spark.api.java.JavaSparkContext;

public class FilebasedSchemaProvider
extends SchemaProvider {
    private final FileSystem fs;
    private final String sourceFile;
    private final String targetFile;
    protected Schema sourceSchema;
    protected Schema targetSchema;

    public FilebasedSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(FilebasedSchemaProviderConfig.SOURCE_SCHEMA_FILE));
        this.sourceFile = ConfigUtils.getStringWithAltKeys(props, FilebasedSchemaProviderConfig.SOURCE_SCHEMA_FILE);
        this.targetFile = ConfigUtils.getStringWithAltKeys((Properties)props, FilebasedSchemaProviderConfig.TARGET_SCHEMA_FILE, this.sourceFile);
        this.fs = HadoopFSUtils.getFs(this.sourceFile, jssc.hadoopConfiguration(), true);
        this.sourceSchema = this.parseSchema(this.sourceFile);
        if (ConfigUtils.containsConfigProperty(props, FilebasedSchemaProviderConfig.TARGET_SCHEMA_FILE)) {
            this.targetSchema = this.parseSchema(this.targetFile);
        }
    }

    private Schema parseSchema(String schemaFile) {
        return FilebasedSchemaProvider.readSchemaFromFile(schemaFile, this.fs, this.config);
    }

    @Override
    public Schema getSourceSchema() {
        return this.sourceSchema;
    }

    @Override
    public Schema getTargetSchema() {
        if (this.targetSchema != null) {
            return this.targetSchema;
        }
        return super.getTargetSchema();
    }

    private static Schema readSchemaFromFile(String schemaPath, FileSystem fs, TypedProperties props) {
        return schemaPath.endsWith(".json") ? FilebasedSchemaProvider.readJsonSchemaFromFile(schemaPath, fs, props) : FilebasedSchemaProvider.readAvroSchemaFromFile(schemaPath, fs, props);
    }

    private static Schema readJsonSchemaFromFile(String schemaPath, FileSystem fs, TypedProperties props) {
        String convertedSchema;
        SchemaRegistryProvider.SchemaConverter schemaConverter;
        String schemaConverterClass = ConfigUtils.getStringWithAltKeys((Properties)props, HoodieSchemaProviderConfig.SCHEMA_CONVERTER, true);
        try {
            ValidationUtils.checkArgument(!StringUtils.isNullOrEmpty(schemaConverterClass), "Schema converter class must be set for the json file based schema provider");
            schemaConverter = (SchemaRegistryProvider.SchemaConverter)ReflectionUtils.loadClass(schemaConverterClass, new Class[]{TypedProperties.class}, new Object[]{props});
        }
        catch (Exception e) {
            throw new HoodieSchemaProviderException("Error loading json schema converter", e);
        }
        String schemaStr = FilebasedSchemaProvider.readSchemaString(schemaPath, fs);
        JsonSchema parsedSchema = new JsonSchema(schemaStr);
        try {
            convertedSchema = schemaConverter.convert((ParsedSchema)parsedSchema);
        }
        catch (IOException e) {
            throw new HoodieSchemaProviderException(String.format("Error converting json schema from file %s", schemaPath), e);
        }
        return new Schema.Parser().parse(convertedSchema);
    }

    private static Schema readAvroSchemaFromFile(String schemaPath, FileSystem fs, TypedProperties props) {
        boolean shouldSanitize = SanitizationUtils.shouldSanitize(props);
        String invalidCharMask = SanitizationUtils.getInvalidCharMask(props);
        String schemaStr = FilebasedSchemaProvider.readSchemaString(schemaPath, fs);
        return SanitizationUtils.parseAvroSchema(schemaStr, shouldSanitize, invalidCharMask);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readSchemaString(String schemaPath, FileSystem fs) {
        try (FSDataInputStream in = fs.open(new Path(schemaPath));){
            String string = FileIOUtils.readAsUTFString((InputStream)in);
            return string;
        }
        catch (IOException ioe) {
            throw new HoodieSchemaProviderException(String.format("Error reading schema from file %s", schemaPath), ioe);
        }
    }

    @Override
    public void refresh() {
        this.sourceSchema = this.parseSchema(this.sourceFile);
        this.targetSchema = this.parseSchema(this.targetFile);
    }
}

