/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.util.Collections;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.utilities.config.HiveSchemaProviderConfig;
import org.apache.hudi.utilities.exception.HoodieSchemaFetchException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.NoSuchDatabaseException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Option;

public class HiveSchemaProvider
extends SchemaProvider {
    private final Schema sourceSchema;
    private Schema targetSchema;

    public HiveSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        ConfigUtils.checkRequiredConfigProperties(props, Collections.singletonList(HiveSchemaProviderConfig.SOURCE_SCHEMA_TABLE));
        String sourceSchemaDatabaseName = ConfigUtils.getStringWithAltKeys((Properties)props, HiveSchemaProviderConfig.SOURCE_SCHEMA_DATABASE, true);
        String sourceSchemaTableName = ConfigUtils.getStringWithAltKeys(props, HiveSchemaProviderConfig.SOURCE_SCHEMA_TABLE);
        SparkSession spark = SparkSession.builder().config(jssc.getConf()).enableHiveSupport().getOrCreate();
        try {
            TableIdentifier sourceSchemaTable = new TableIdentifier(sourceSchemaTableName, Option.apply(sourceSchemaDatabaseName));
            StructType sourceSchema = spark.sessionState().catalog().getTableMetadata(sourceSchemaTable).schema();
            this.sourceSchema = AvroConversionUtils.convertStructTypeToAvroSchema((DataType)sourceSchema, (String)sourceSchemaTableName, (String)("hoodie." + sourceSchemaDatabaseName));
        }
        catch (NoSuchDatabaseException | NoSuchTableException e) {
            throw new HoodieSchemaFetchException(String.format("Can't find Hive table: %s.%s", sourceSchemaDatabaseName, sourceSchemaTableName), e);
        }
        if (ConfigUtils.containsConfigProperty(props, HiveSchemaProviderConfig.TARGET_SCHEMA_TABLE)) {
            String targetSchemaDatabaseName = ConfigUtils.getStringWithAltKeys((Properties)props, HiveSchemaProviderConfig.TARGET_SCHEMA_DATABASE, true);
            String targetSchemaTableName = ConfigUtils.getStringWithAltKeys(props, HiveSchemaProviderConfig.TARGET_SCHEMA_TABLE);
            try {
                TableIdentifier targetSchemaTable = new TableIdentifier(targetSchemaTableName, Option.apply(targetSchemaDatabaseName));
                StructType targetSchema = spark.sessionState().catalog().getTableMetadata(targetSchemaTable).schema();
                this.targetSchema = AvroConversionUtils.convertStructTypeToAvroSchema((DataType)targetSchema, (String)targetSchemaTableName, (String)("hoodie." + targetSchemaDatabaseName));
            }
            catch (NoSuchDatabaseException | NoSuchTableException e) {
                throw new HoodieSchemaFetchException(String.format("Can't find Hive table: %s.%s", targetSchemaDatabaseName, targetSchemaTableName), e);
            }
        }
    }

    @Override
    public Schema getSourceSchema() {
        return this.sourceSchema;
    }

    @Override
    public Schema getTargetSchema() {
        if (this.targetSchema != null) {
            return this.targetSchema;
        }
        return super.getTargetSchema();
    }
}

