/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.RetryHelper;
import org.apache.hudi.utilities.config.KafkaSourceConfig;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class HoodieRetryingKafkaConsumer
extends KafkaConsumer {
    private final long maxRetryIntervalMs;
    private final int maxRetryCount;
    private final long initialRetryIntervalMs;
    private final String retryExceptionsList;

    public HoodieRetryingKafkaConsumer(TypedProperties config, Map<String, Object> kafkaParams) {
        super(kafkaParams);
        this.maxRetryIntervalMs = config.getLong(KafkaSourceConfig.MAX_RETRY_INTERVAL_MS.key(), KafkaSourceConfig.MAX_RETRY_INTERVAL_MS.defaultValue());
        this.maxRetryCount = config.getInteger(KafkaSourceConfig.MAX_RETRY_COUNT.key(), KafkaSourceConfig.MAX_RETRY_COUNT.defaultValue());
        this.initialRetryIntervalMs = config.getLong(KafkaSourceConfig.INITIAL_RETRY_INTERVAL_MS.key(), KafkaSourceConfig.INITIAL_RETRY_INTERVAL_MS.defaultValue());
        this.retryExceptionsList = config.getString(KafkaSourceConfig.RETRY_EXCEPTIONS.key(), KafkaSourceConfig.RETRY_EXCEPTIONS.defaultValue());
    }

    public Map<TopicPartition, Long> beginningOffsets(Collection partitions) {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start(() -> super.beginningOffsets(partitions));
    }

    public Map<TopicPartition, Long> endOffsets(Collection partitions) {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start(() -> super.endOffsets(partitions));
    }

    public List<PartitionInfo> partitionsFor(String topic) {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start(() -> super.partitionsFor(topic));
    }

    public Map<TopicPartition, OffsetAndTimestamp> offsetsForTimes(Map timestampsToSearch) {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start(() -> super.offsetsForTimes(timestampsToSearch));
    }

    public Map<String, List<PartitionInfo>> listTopics() {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start(() -> super.listTopics());
    }

    public OffsetAndMetadata committed(TopicPartition partition) {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryCount, this.initialRetryIntervalMs, this.retryExceptionsList).start(() -> super.committed(partition));
    }
}

