/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.debezium;

import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.utilities.ingestion.HoodieIngestionMetrics;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.debezium.DebeziumSource;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;

public class MysqlDebeziumSource
extends DebeziumSource {
    private final SQLContext sqlContext;
    private final String generateUniqueSeqUdfFn = "mysql_generate_order_key";

    public MysqlDebeziumSource(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider, HoodieIngestionMetrics metrics) {
        super(props, sparkContext, sparkSession, schemaProvider, metrics);
        this.sqlContext = sparkSession.sqlContext();
        this.sqlContext.udf().register("mysql_generate_order_key", MysqlDebeziumSource::generateUniqueSequence, DataTypes.StringType);
    }

    @Override
    protected Dataset<Row> processDataset(Dataset<Row> rowDataset) {
        Dataset flattenedDataset = rowDataset;
        if (rowDataset.columns().length > 0) {
            Dataset insertedOrUpdatedData = rowDataset.selectExpr(new String[]{String.format("%s as %s", "op", "_change_operation_type"), String.format("%s as %s", "ts_ms", "_upstream_event_processed_ts_ms"), String.format("%s as %s", "source.name", "db_shard_source_partition"), String.format("%s as %s", "source.ts_ms", "_event_origin_ts_ms"), String.format("%s as %s", "source.file", "_event_bin_file"), String.format("%s as %s", "source.pos", "_event_pos"), String.format("%s as %s", "source.row", "_event_row"), String.format("%s.*", "after")}).filter(rowDataset.col("op").notEqual((Object)"d"));
            Dataset deletedData = rowDataset.selectExpr(new String[]{String.format("%s as %s", "op", "_change_operation_type"), String.format("%s as %s", "ts_ms", "_upstream_event_processed_ts_ms"), String.format("%s as %s", "source.name", "db_shard_source_partition"), String.format("%s as %s", "source.ts_ms", "_event_origin_ts_ms"), String.format("%s as %s", "source.file", "_event_bin_file"), String.format("%s as %s", "source.pos", "_event_pos"), String.format("%s as %s", "source.row", "_event_row"), String.format("%s.*", "before")}).filter(rowDataset.col("op").equalTo((Object)"d"));
            flattenedDataset = insertedOrUpdatedData.union(deletedData);
        }
        return flattenedDataset.withColumn("_event_seq", functions.callUDF((String)"mysql_generate_order_key", (Column[])new Column[]{flattenedDataset.col("_event_bin_file"), flattenedDataset.col("_event_pos")}));
    }

    private static String generateUniqueSequence(String fileId, Long pos) {
        return fileId.substring(fileId.lastIndexOf(46) + 1).concat("." + pos);
    }
}

