/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import io.hops.hudi.com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.utilities.config.CloudSourceConfig;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrSourceCloudStorageHelper {
    private static final Logger LOG = LoggerFactory.getLogger(IncrSourceCloudStorageHelper.class);

    public static Option<Dataset<Row>> fetchFileData(SparkSession spark, List<String> filepaths, TypedProperties props, String fileFormat) {
        if (filepaths.isEmpty()) {
            return Option.empty();
        }
        DataFrameReader dfReader = IncrSourceCloudStorageHelper.getDataFrameReader(spark, props, fileFormat);
        Dataset fileDataDs = dfReader.load(filepaths.toArray(new String[0]));
        return Option.of(fileDataDs);
    }

    private static DataFrameReader getDataFrameReader(SparkSession spark, TypedProperties props, String fileFormat) {
        DataFrameReader dataFrameReader = spark.read().format(fileFormat);
        if (StringUtils.isNullOrEmpty(ConfigUtils.getStringWithAltKeys((Properties)props, CloudSourceConfig.SPARK_DATASOURCE_OPTIONS, true))) {
            return dataFrameReader;
        }
        ObjectMapper mapper = new ObjectMapper();
        Map sparkOptionsMap = null;
        try {
            sparkOptionsMap = mapper.readValue(ConfigUtils.getStringWithAltKeys(props, CloudSourceConfig.SPARK_DATASOURCE_OPTIONS), Map.class);
        }
        catch (IOException e) {
            throw new HoodieException(String.format("Failed to parse sparkOptions: %s", ConfigUtils.getStringWithAltKeys(props, CloudSourceConfig.SPARK_DATASOURCE_OPTIONS)), e);
        }
        LOG.info(String.format("sparkOptions loaded: %s", sparkOptionsMap));
        return dataFrameReader.options(sparkOptionsMap);
    }
}

