/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import com.google.crypto.tink.subtle.Base64;
import java.util.Objects;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.hash.HashID;
import org.apache.hudi.utilities.config.KafkaSourceConfig;
import org.apache.hudi.utilities.exception.HoodieReadFromSourceException;
import org.apache.hudi.utilities.schema.SchemaProvider;

public class KafkaSourceUtil {
    public static final String NATIVE_KAFKA_CONSUMER_GROUP_ID = "group.id";
    public static final int GROUP_ID_MAX_BYTES_LENGTH = 255;

    public static void configureSchemaDeserializer(SchemaProvider schemaProvider, TypedProperties props) {
        if (schemaProvider == null || Objects.isNull(schemaProvider.getSourceSchema())) {
            throw new HoodieReadFromSourceException("SchemaProvider has to be set to use KafkaAvroSchemaDeserializer");
        }
        props.put(KafkaSourceConfig.KAFKA_VALUE_DESERIALIZER_SCHEMA.key(), schemaProvider.getSourceSchema().toString());
        String groupId = props.getString(NATIVE_KAFKA_CONSUMER_GROUP_ID, "");
        String schemaHash = Base64.encode((byte[])HashID.hash(schemaProvider.getSourceSchema().toString(), HashID.Size.BITS_128));
        String updatedConsumerGroup = groupId.isEmpty() ? schemaHash : StringUtils.concatenateWithThreshold(String.format("%s_", groupId), schemaHash, 255);
        props.put(NATIVE_KAFKA_CONSUMER_GROUP_ID, updatedConsumerGroup);
    }
}

