/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources.helpers;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hudi.internal.schema.HoodieSchemaException;
import org.apache.hudi.utilities.sources.helpers.MercifulJsonToRowConverter;
import org.apache.spark.sql.Row;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class RowConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Schema schema;
    private final String schemaStr;
    private final String invalidCharMask;
    private final boolean shouldSanitize;
    private transient MercifulJsonToRowConverter jsonConverter;

    public RowConverter(Schema schema, boolean shouldSanitize, String invalidCharMask) {
        this.schemaStr = schema.toString();
        this.schema = schema;
        this.shouldSanitize = shouldSanitize;
        this.invalidCharMask = invalidCharMask;
    }

    private void initSchema() {
        if (this.schema == null) {
            Schema.Parser parser = new Schema.Parser();
            this.schema = parser.parse(this.schemaStr);
        }
    }

    private void initJsonConvertor() {
        if (this.jsonConverter == null) {
            this.jsonConverter = new MercifulJsonToRowConverter(this.shouldSanitize, this.invalidCharMask);
        }
    }

    public Row fromJson(String json) {
        try {
            this.initSchema();
            this.initJsonConvertor();
            return this.jsonConverter.convertToRow(json, this.schema);
        }
        catch (IllegalArgumentException e) {
            throw new HoodieSchemaException("Failed to convert schema from json to avro. json string is invalid.", e);
        }
        catch (Exception e) {
            throw new HoodieSchemaException("Failed to convert schema from json to avro: " + json, e);
        }
    }

    public Either<Row, String> fromJsonToRowWithError(String json) {
        Row row;
        try {
            row = this.fromJson(json);
        }
        catch (Exception e) {
            return new Right<Row, String>(json);
        }
        return new Left<Row, String>(row);
    }

    public Schema getSchema() {
        try {
            return new Schema.Parser().parse(this.schemaStr);
        }
        catch (Exception e) {
            throw new HoodieSchemaException("Failed to parse json schema: " + this.schemaStr, e);
        }
    }
}

