/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.streamer;

import java.util.Objects;

public class ErrorEvent<T> {
    private final ErrorReason reason;
    private final T payload;

    public ErrorEvent(T payload, ErrorReason reason) {
        this.payload = payload;
        this.reason = reason;
    }

    public T getPayload() {
        return this.payload;
    }

    public ErrorReason getReason() {
        return this.reason;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorEvent that = (ErrorEvent)o;
        return this.reason == that.reason && Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.payload});
    }

    public static enum ErrorReason {
        JSON_AVRO_DESERIALIZATION_FAILURE,
        JSON_ROW_DESERIALIZATION_FAILURE,
        AVRO_DESERIALIZATION_FAILURE,
        HUDI_WRITE_FAILURES,
        CUSTOM_TRANSFORMER_FAILURE,
        INVALID_RECORD_SCHEMA,
        RECORD_CREATION;

    }
}

