/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.streamer;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.utilities.streamer.PostWriteTerminationStrategy;
import org.apache.spark.api.java.JavaRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoNewDataTerminationStrategy
implements PostWriteTerminationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(NoNewDataTerminationStrategy.class);
    public static final String MAX_ROUNDS_WITHOUT_NEW_DATA_TO_SHUTDOWN = "max.rounds.without.new.data.to.shutdown";
    public static final int DEFAULT_MAX_ROUNDS_WITHOUT_NEW_DATA_TO_SHUTDOWN = 3;
    private final int numTimesNoNewDataToShutdown;
    private int numTimesNoNewData = 0;

    public NoNewDataTerminationStrategy(TypedProperties properties2) {
        this.numTimesNoNewDataToShutdown = properties2.getInteger(MAX_ROUNDS_WITHOUT_NEW_DATA_TO_SHUTDOWN, 3);
    }

    @Override
    public boolean shouldShutdown(Option<JavaRDD<WriteStatus>> writeStatuses) {
        int n = this.numTimesNoNewData = writeStatuses.isPresent() ? 0 : this.numTimesNoNewData + 1;
        if (this.numTimesNoNewData >= this.numTimesNoNewDataToShutdown) {
            LOG.info("Shutting down on continuous mode as there is no new data for " + this.numTimesNoNewData);
            return true;
        }
        return false;
    }
}

