/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.hilbert;

public final class Range {
    private final long low;
    private final long high;

    public Range(long low, long high) {
        this.low = Math.min(low, high);
        this.high = Math.max(low, high);
    }

    public static Range create(long low, long high) {
        return new Range(low, high);
    }

    public static Range create(long value) {
        return new Range(value, value);
    }

    public long low() {
        return this.low;
    }

    public long high() {
        return this.high;
    }

    public boolean contains(long value) {
        return this.low <= value && value <= this.high;
    }

    public String toString() {
        return "Range [low=" + this.low + ", high=" + this.high + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (int)(this.high ^ this.high >>> 32);
        result2 = 31 * result2 + (int)(this.low ^ this.low >>> 32);
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Range other = (Range)obj;
        if (this.high != other.high) {
            return false;
        }
        return this.low == other.low;
    }

    public Range join(Range range) {
        return Range.create(Math.min(this.low, range.low), Math.max(this.high, range.high));
    }
}

