/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.definitions;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.ide.highlighter.JavaClassFileType;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.fileTypes.FileTypeRegistry;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Computable;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionProvider;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a$\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u000e\b\u0004\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00070\tH\u0086\b\u00a2\u0006\u0002\u0010\n\u001a\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u00020\r\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\fH\u0002\u001a\n\u0010\u0010\u001a\u00020\u000f*\u00020\f\u00a8\u0006\u0011"}, d2={"findScriptDefinitionByFilePath", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "file", "Ljava/io/File;", "runReadAction", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "findScriptDefinition", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiFile;", "isKotlinFileType", "", "isNonScript", "kotlin-scripting-compiler-impl"})
public final class DefinitionsKt {
    public static final <T> T runReadAction(@NotNull Function0<? extends T> runnable) {
        int $i$f$runReadAction = 0;
        Intrinsics.checkParameterIsNotNull(runnable, "runnable");
        return (T)ApplicationManager.getApplication().runReadAction(new Computable<T>(runnable){
            final /* synthetic */ Function0 $runnable;

            public final T compute() {
                return (T)this.$runnable.invoke();
            }
            {
                this.$runnable = function0;
            }
        });
    }

    @Nullable
    public static final ScriptDefinition findScriptDefinition(@NotNull PsiFile $this$findScriptDefinition) {
        Intrinsics.checkParameterIsNotNull($this$findScriptDefinition, "$this$findScriptDefinition");
        if (!($this$findScriptDefinition instanceof KtFile)) {
            return null;
        }
        VirtualFile virtualFile = ((KtFile)$this$findScriptDefinition).getVirtualFile();
        if (virtualFile == null) {
            PsiFile psiFile = ((KtFile)$this$findScriptDefinition).getOriginalFile();
            Intrinsics.checkExpressionValueIsNotNull(psiFile, "originalFile");
            virtualFile = psiFile.getVirtualFile();
        }
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        if (DefinitionsKt.isNonScript(file)) {
            return null;
        }
        Project project = ((KtFile)$this$findScriptDefinition).getProject();
        Intrinsics.checkExpressionValueIsNotNull(project, "project");
        return DefinitionsKt.findScriptDefinitionByFilePath(project, new File(file.getPath()));
    }

    @Nullable
    public static final ScriptDefinition findScriptDefinition(@NotNull VirtualFile $this$findScriptDefinition, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull($this$findScriptDefinition, "$this$findScriptDefinition");
        Intrinsics.checkParameterIsNotNull(project, "project");
        if (!$this$findScriptDefinition.isValid() || DefinitionsKt.isNonScript($this$findScriptDefinition)) {
            return null;
        }
        boolean $i$f$runReadAction = false;
        if (ApplicationManager.getApplication().runReadAction(new Computable<T>($this$findScriptDefinition, project){
            final /* synthetic */ VirtualFile $this_findScriptDefinition$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$this_findScriptDefinition$inlined = virtualFile;
                this.$project$inlined = project;
            }

            public final T compute() {
                boolean bl = false;
                PsiFile psiFile = PsiManager.getInstance((Project)this.$project$inlined).findFile(this.$this_findScriptDefinition$inlined);
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                return (T)((KtFile)psiFile);
            }
        }) == null) {
            return null;
        }
        return DefinitionsKt.findScriptDefinitionByFilePath(project, new File($this$findScriptDefinition.getPath()));
    }

    private static final ScriptDefinition findScriptDefinitionByFilePath(Project project, File file) {
        ScriptDefinitionProvider scriptDefinitionProvider = ScriptDefinitionProvider.Companion.getInstance(project);
        if (scriptDefinitionProvider == null) {
            throw (Throwable)new IllegalStateException("Unable to get script definition: ScriptDefinitionProvider is not configured.");
        }
        ScriptDefinitionProvider scriptDefinitionProvider2 = scriptDefinitionProvider;
        ScriptDefinition scriptDefinition = scriptDefinitionProvider2.findDefinition(file);
        if (scriptDefinition == null) {
            scriptDefinition = scriptDefinitionProvider2.getDefaultDefinition();
        }
        return scriptDefinition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNonScript(@NotNull VirtualFile $this$isNonScript) {
        Intrinsics.checkParameterIsNotNull($this$isNonScript, "$this$isNonScript");
        if ($this$isNonScript.isDirectory()) return true;
        if (Intrinsics.areEqual($this$isNonScript.getExtension(), "kt")) return true;
        String string = $this$isNonScript.getExtension();
        JavaClassFileType javaClassFileType = JavaClassFileType.INSTANCE;
        Intrinsics.checkExpressionValueIsNotNull(javaClassFileType, "JavaClassFileType.INSTANCE");
        if (Intrinsics.areEqual(string, javaClassFileType.getDefaultExtension())) return true;
        if (DefinitionsKt.isKotlinFileType($this$isNonScript)) return false;
        return true;
    }

    private static final boolean isKotlinFileType(@NotNull VirtualFile $this$isKotlinFileType) {
        if (Intrinsics.areEqual($this$isKotlinFileType.getExtension(), KotlinParserDefinition.STD_SCRIPT_SUFFIX)) {
            return true;
        }
        FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
        return Intrinsics.areEqual(typeRegistry.getFileTypeByFile($this$isKotlinFileType), KotlinFileType.INSTANCE) || Intrinsics.areEqual(typeRegistry.getFileTypeByFileName($this$isKotlinFileType.getName()), KotlinFileType.INSTANCE);
    }
}

