/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.helper;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.connect.transaction.TransactionParticipant;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.sink.SinkRecord;
import org.apache.kafka.connect.sink.SinkTaskContext;

public class MockKafkaConnect
implements SinkTaskContext {
    private final TopicPartition testPartition;
    private TransactionParticipant participant;
    private long currentKafkaOffset;
    private boolean isPaused;
    private boolean isResetOffset;

    public MockKafkaConnect(TopicPartition testPartition) {
        this.testPartition = testPartition;
        this.isPaused = false;
        this.currentKafkaOffset = 0L;
        this.isResetOffset = false;
    }

    public void setParticipant(TransactionParticipant participant) {
        this.participant = participant;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public boolean isResumed() {
        return !this.isPaused;
    }

    public long getCurrentKafkaOffset() {
        return this.currentKafkaOffset;
    }

    public void pause(TopicPartition ... partitions) {
        if (Arrays.stream(partitions).allMatch(arg_0 -> ((TopicPartition)this.testPartition).equals(arg_0))) {
            this.isPaused = true;
        }
    }

    public void resume(TopicPartition ... partitions) {
        if (Arrays.stream(partitions).allMatch(arg_0 -> ((TopicPartition)this.testPartition).equals(arg_0))) {
            this.isPaused = false;
        }
    }

    public void offset(Map<TopicPartition, Long> offsets) {
        for (TopicPartition tp : offsets.keySet()) {
            if (!tp.equals((Object)this.testPartition)) continue;
            this.resetOffset(offsets.get(tp));
        }
    }

    public void offset(TopicPartition tp, long offset) {
        if (tp.equals((Object)this.testPartition)) {
            this.resetOffset(offset);
        }
    }

    public Map<String, String> configs() {
        return null;
    }

    public void timeout(long timeoutMs) {
    }

    public Set<TopicPartition> assignment() {
        return null;
    }

    public void requestCommit() {
    }

    public int publishBatchRecordsToParticipant(int numRecords) {
        do {
            this.isResetOffset = false;
            for (int i = 1; i <= numRecords; ++i) {
                this.participant.buffer(this.getNextKafkaRecord());
            }
            this.participant.processRecords();
        } while (this.isResetOffset);
        return numRecords;
    }

    private SinkRecord getNextKafkaRecord() {
        return new SinkRecord(this.testPartition.topic(), this.testPartition.partition(), Schema.OPTIONAL_BYTES_SCHEMA, (Object)("key-" + this.currentKafkaOffset).getBytes(), Schema.OPTIONAL_BYTES_SCHEMA, (Object)"value".getBytes(), this.currentKafkaOffset++);
    }

    private void resetOffset(long newOffset) {
        this.currentKafkaOffset = newOffset;
        this.isResetOffset = true;
    }
}

